<?php

namespace WFCO\GetResponse;

#[\AllowDynamicProperties]
class Update_Tags_By_Id extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'api_key', 'contact_id', 'tags' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gr_update_tags_by_id';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		if ( ! is_array( $this->data['tags'] ) ) {
			return array(
				'response' => 502,
				'body'     => array( 'Tags data is invalid' ),
			);
		}

		$params = array( 'tags' => array() );
		foreach ( $this->data['tags'] as $tag ) {
			$params['tags'][] = array(
				'tagId' => $tag
			);
		}
		$params['bwfan_con_source'] = 'autonami';
		\BWFCO_GetResponse::set_headers( $this->data['api_key'] );

		return $this->make_wp_requests( $this->get_endpoint(), wp_json_encode( $params ), \BWFCO_GetResponse::get_headers(), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_GetResponse::get_endpoint() . 'contacts/' . $this->data['contact_id'] . '/tags';
	}

}

return 'WFCO\GetResponse\Update_Tags_By_Id';
