<?php

namespace WFCO\GoogleSheet;

#[\AllowDynamicProperties]
class Insert_Data extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {

		$this->required_fields = array( 'spreadsheet_id', 'worksheet_title', 'worksheet_data' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gs_insert_data';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$client = \BWFCO_Google_Sheets::get_google_client();
		if ( false === $client ) {
			return false;
		}

		$service       = new \Google_Service_BWFSheets( $client );
		$column_values = array();
		$range         = $this->data['worksheet_title'];

		/** getting the last row of the sheet to append data properly on sheet */
		try {
			$response_sheet_data = $service->spreadsheets_values->get( $this->data['spreadsheet_id'], $range );
		} catch ( \Exception $exception ) {
			$errors = $exception->getErrors();

			return array(
				0 => $exception->getCode(),
				1 => $errors[0]['message'],
			);
		}

		$get_values = $response_sheet_data->getValues();
		$last_row   = is_array( $get_values ) ? count( $get_values ) : 0;
		$append_row = $last_row + 1;

		$range = $this->data['worksheet_title'] . '!A' . $append_row . ':Z';

		/** earlier using ksort now change it with uksort to sorting the data alphabetically **/
		uksort( $this->data['worksheet_data'], function ( $a, $b ) {
			return $this->alpha2num( $a ) <=> $this->alpha2num( $b );
		} );

		$temp_columns = $this->data['worksheet_data'];
		end( $temp_columns );
		$key = key( $temp_columns );

		$all_columns = is_array( $this->data['worksheet_column'] ) && count( $this->data['worksheet_column'] ) > 0 ? $this->data['worksheet_column'] : $this->get_all_columns();
		foreach ( $all_columns as $column ) {
			if ( array_key_exists( $column, $this->data['worksheet_data'] ) ) {
				$column_values[ $column ] = $this->data['worksheet_data'][ $column ];
			} else {
				$column_values[ $column ] = '';
			}

			if ( $key === $column ) {
				break;
			}
		}

		$values = array();
		foreach ( $column_values as $key => $col_val ) {
			if ( '' === $col_val ) {
				continue;
			}
			$values[] = array(
				'range'          => $this->data['worksheet_title'] . '!' . $key . $append_row,
				'majorDimension' => 'ROWS',
				'values'         => array( array( $col_val ) ),
			);
		}

		$body   = new \Google_Service_Sheets_BWFBatchUpdateValuesRequest( array(

			'valueInputOption' => 'USER_ENTERED',
			'data'             => $values,
		) );
		$params = array();

		try {
			$service->spreadsheets_values->batchUpdate( $this->data['spreadsheet_id'], $body, $params );
		} catch ( \Exception $exception ) { //when exception occur in update then using the append function
			$insert_column_values = array();
			foreach ( $all_columns as $column ) {
				if ( array_key_exists( $column, $this->data['worksheet_data'] ) && ! empty( $this->data['worksheet_data'][ $column ] ) ) {
					$insert_column_values[] = $this->data['worksheet_data'][ $column ];
				} else {
					$insert_column_values[] = '';
				}

				if ( $key === $column ) {
					break;
				}
			}

			$values = array( $insert_column_values );
			$body   = new \Google_Service_Sheets_BWFValueRange( array(
				'values' => $values,
			) );
			$params = array(
				'valueInputOption' => 'USER_ENTERED',
			);

			try {
				$service->spreadsheets_values->append( $this->data['spreadsheet_id'], $range, $body, $params );
			} catch ( \Exception $exception ) {
				$errors = $exception->getErrors();

				return array(
					0 => $exception->getCode(),
					1 => $errors[0]['message'],
				);
			}
		}

		return true;
	}

	/**
	 * Converts an alphabetic string into an integer.
	 *
	 * @param $a - This is the number to convert.
	 *
	 * @return float|int
	 */
	public function alpha2num( $a ) {
		$r = 0;
		$l = strlen( $a );
		for ( $i = 0; $i < $l; $i ++ ) {
			$r += pow( 26, $i ) * ( ord( $a[ $l - $i - 1 ] ) - 0x40 );
		}

		return $r - 1;
	}

	public function get_all_columns() {
		return array(
			'A' => 'A',
			'B' => 'B',
			'C' => 'C',
			'D' => 'D',
			'E' => 'E',
			'F' => 'F',
			'G' => 'G',
			'H' => 'H',
			'I' => 'I',
			'J' => 'J',
			'K' => 'K',
			'L' => 'L',
			'M' => 'M',
			'N' => 'N',
			'O' => 'O',
			'P' => 'P',
			'Q' => 'Q',
			'R' => 'R',
			'S' => 'S',
			'T' => 'T',
			'U' => 'U',
			'V' => 'V',
			'W' => 'W',
			'X' => 'X',
			'Y' => 'Y',
			'Z' => 'Z',
		);
	}


}

return 'WFCO\GoogleSheet\Insert_Data';
