<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Remove_From_List extends WFCO_Klaviyo_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'list_id', 'email' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_remove_from_list';
	}

	public function process_klaviyo_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$connectors = \WFCO_Load_Connectors::get_instance();
		$call       = $connectors->get_call( 'wfco_klaviyo_get_profile' );
		$call->set_data( $this->data );
		$result = $call->process();

		$profile_id = isset( $result['payload']['data']['0']['id'] ) ? $result['payload']['data']['0']['id'] : 0;
		$user_data  = array(
			[
				'type' => 'profile',
				'id'   => $profile_id
			]
		);

		$params = array(
			'data'             => $user_data,
			'bwfan_con_source' => 'autonami'
		);

		return $this->do_klaviyo_call( wp_json_encode( $params ), \BWF_CO::$DELETE );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Klaviyo::$api_end_point . 'lists/' . $this->data['list_id'] . '/relationships/profiles/';
	}
}

return 'WFCO\Klaviyo\Remove_From_List';
