<?php
/**
 * Plugin Name: FunnelKit Automations Connectors
 * Plugin URI: https://funnelkit.com/wordpress-marketing-automation-autonami/
 * Description: Take your marketing automation game notches up by unlocking third-party integrations- like with Active Campaign, Drip, ConvertKit, to add a tag/add to a list/start automation etc. And even with Slack, Twilio & more. Many more apps are joining the party.
 * Version: 2.8.0
 * Author: FunnelKit
 * Author URI: https://funnelkit.com
 * License: GPLv3 or later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain: autonami-automations-connectors
 *
 * Requires at least: 5.0
 * Tested up to: 6.4.3
 * WooFunnels: true
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

#[AllowDynamicProperties]
final class WFCO_Autonami_Connectors_Core {

	/**
	 * @var WFCO_Autonami_Connectors_Core
	 */
	public static $_instance = null;
	public $sync = null;

	private function __construct() {
		$this->sync = true;

		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->load_commons();
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_AUTONAMI_CONNECTORS_VERSION', '2.8.0' );
		define( 'WFCO_AUTONAMI_CONNECTORS_SLUG', 'autonami-automations-connectors' );
		define( 'WFCO_AUTONAMI_CONNECTORS_FULL_NAME', 'FunnelKit Automations Connectors' );
		define( 'WFCO_AUTONAMI_CONNECTORS_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_AUTONAMI_CONNECTORS_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_AUTONAMI_CONNECTORS_PLUGIN_FILE ) ) );
		define( 'WFCO_AUTONAMI_CONNECTORS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_AUTONAMI_CONNECTORS_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_AUTONAMI_CONNECTORS_ENCODE', sha1( WFCO_AUTONAMI_CONNECTORS_PLUGIN_BASENAME ) );

		add_action( 'bwfan_loaded', [ $this, 'add_support' ], 15 );
		add_action( 'bwfan_loaded', [ $this, 'load_includes' ] );
	}

	public function load_includes() {
		/** Connector Common */
		require_once WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/includes/class-bwfan-connectors-common.php';
		BWFAN_Connectors_Common::init();

		$this->load_rules();
	}

	/**
	 * Load common hooks
	 */
	public function load_commons() {
		$this->load_hooks();
	}

	public function load_hooks() {
		add_action( 'wfco_load_connectors', [ $this, 'load_connector_classes' ] );
		add_action( 'bwfan_automations_loaded', [ $this, 'load_autonami_classes' ] );
		add_action( 'bwfan_merge_tags_loaded', [ $this, 'load_tag_classes' ], 12 );

		add_action( 'bwfan_load_custom_search_classes', [ $this, 'load_custom_search_classes' ] );

		/** Initialize Localization */
		add_action( 'init', array( $this, 'localization' ) );

		/** HPOS compatibility */
		add_action( 'before_woocommerce_init', [ $this, 'hpos_compatibility_declaration' ] );
	}

	public static function get_instance() {
		if ( null === self::$_instance ) {
			self::$_instance = new self;
		}

		return self::$_instance;
	}

	/**
	 * Add License Support to basic connector
	 */
	public function add_support() {
		include_once( WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/class-bwfan-support.php' );
	}

	/**
	 * Load Connector Classes
	 */
	public function load_connector_classes() {
		$resource_dir = WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/connectors';

		foreach ( glob( $resource_dir . '/*' ) as $connector ) {

			$connector = apply_filters( 'bwfan_maybe_load_connector', $connector );

			if ( false === $connector ) {
				continue;
			}

			if ( strpos( $connector, 'index.php' ) !== false ) {
				continue;
			}

			$_field_filename = $connector . '/connector.php';
			if ( file_exists( $_field_filename ) ) {
				require_once( $_field_filename );
			}
		}

		do_action( 'wfco_basic_autonami_connectors_all_connectors_loaded', $this );
	}

	/**
	 * Load Autonami Integration classes
	 */
	public function load_autonami_classes() {
		$this->load_classes( 'autonami' );

		do_action( 'wfco_basic_autonami_connectors_all_integrations_loaded', $this );
	}

	public function load_custom_search_classes() {
		$this->load_classes( 'includes/search' );

		do_action( 'wfco_custom_search_classes_loaded', $this );
	}

	public function load_classes( $folder ) {
		$resource_dir = WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/connectors';

		foreach ( glob( $resource_dir . '/*' ) as $connector ) {
			if ( strpos( $connector, 'index.php' ) !== false ) {
				continue;
			}
			foreach ( glob( $connector . '/' . $folder . '/class-*.php' ) as $_field_filename ) {
				require_once( $_field_filename );
			}
		}
	}

	/**
	 * Load Active Campaign Merge Tag classes
	 */
	public function load_tag_classes() {
		$connector = array( 'activecampaign', 'drip', 'twilio' );
		foreach ( $connector as $conn ) {
			$resource_dir = WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/connectors/' . $conn . '/autonami/merge_tags';
			foreach ( glob( $resource_dir . '/class-*.php' ) as $_field_filename ) {
				require_once( $_field_filename );
			}
		}

	}

	private function load_rules() {

		include_once WFCO_AUTONAMI_CONNECTORS_PLUGIN_DIR . '/rules/class-bwfan-rules.php';
	}

	public function localization() {
		load_plugin_textdomain( 'autonami-automations-connectors', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
	}

	/**
	 * Declares compatibility with WooCommerce HPOS
	 *
	 * @return void
	 */
	public function hpos_compatibility_declaration() {
		if ( ! class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			return;
		}
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', WFCO_AUTONAMI_CONNECTORS_PLUGIN_FILE, true );
	}

}

if ( ! function_exists( 'WFCO_Autonami_Connectors_Core' ) ) {

	/**
	 * Global Common function to load all the classes
	 * @return WFCO_Autonami_Connectors_Core
	 */
	function WFCO_Autonami_Connectors_Core() {  //@codingStandardsIgnoreLine
		return WFCO_Autonami_Connectors_Core::get_instance();
	}
}

WFCO_Autonami_Connectors_Core();
