<?php

namespace WFCO\AC;

#[\AllowDynamicProperties]
class Create_Deal_Note extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'api_url', 'deal_id', 'email', 'deal_note' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_ac_create_deal_note';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		\BWFCO_ActiveCampaign::set_headers( $this->data['api_key'] );

		return $this->create_deal_note();
	}

	/**
	 * Create a deal note.
	 *
	 * @return array|mixed|object|string
	 */
	public function create_deal_note() {
		$api_action  = 'deals';
		$params_data = array(
			'note' => array(
				'note' => $this->data['deal_note'],
			),
		);

		$params_data  = wp_json_encode( $params_data );
		$endpoint_url = \BWFCO_ActiveCampaign::get_endpoint_url( $this->data['api_url'], $api_action );
		$endpoint_url = $endpoint_url . '/' . $this->data['deal_id'] . '/notes';
		$result       = $this->make_wp_requests( $endpoint_url, $params_data, \BWFCO_ActiveCampaign::get_headers(), \BWF_CO::$POST );

		return $result;
	}

}

return 'WFCO\\AC\\Create_Deal_Note';
