<?php

namespace WFCO\AC;

#[\AllowDynamicProperties]
class Get_Contact_By_Email extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'api_url', 'email' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_ac_get_contact_by_email';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		\BWFCO_ActiveCampaign::set_headers( $this->data['api_key'] );

		return $this->get_contact_by_email();
	}

	/**
	 * View a single contact by contact email.
	 *
	 * @return array|mixed|object|string
	 */
	public function get_contact_by_email() {
		$api_action   = 'contacts';
		$params_data  = array();
		$endpoint_url = \BWFCO_ActiveCampaign::get_endpoint_url( $this->data['api_url'], $api_action );
		$endpoint_url = $endpoint_url . '?filters[email]=' . urlencode( $this->data['email'] );
		$result       = $this->make_wp_requests( $endpoint_url, $params_data, \BWFCO_ActiveCampaign::get_headers(), \BWF_CO::$GET );

		return $result;
	}

}

return 'WFCO\\AC\\Get_Contact_By_Email';
