<?php

#[AllowDynamicProperties]
final class BWFAN_Hubspot_Create_Deal extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Create Deal', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action creates the deal in Hubspot', 'autonami-automations-connectors' );
		$this->action_priority = 50;
		$this->included_events = array(
			'wc_new_order',
			'wc_product_purchased',
		);
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set            = array();
		$data_to_set['api_key'] = $integration_object->get_settings( 'api_key' );

		/** Set Email if global email is empty */
		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		$data_to_set['order_id'] = $task_meta['global']['order_id'];

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set             = array();
		$data_to_set['api_key']  = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['email']    = $automation_data['global']['email'];
		$data_to_set['order_id'] = $automation_data['global']['order_id'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		return $result;
	}

	public function handle_response_v2( $result ) {
		if ( ! isset( $result['status'] ) ) {
			return $this->error_response( __( 'Unknown API Exception', 'autonami-automations-connectors' ) );
		}

		$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
		if ( 4 === absint( $result['status'] ) ) {
			return $this->error_response( $message );
		}

		return $this->success_message( $message );


	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [];
	}

}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Hubspot_Create_Deal';
