<?php

#[AllowDynamicProperties]
class BWFAN_Hubspot_Contact_Email extends BWFAN_Merge_Tag {

	private static $instance = null;

	public function __construct() {
		$this->tag_name        = 'hubspot_contact_email';
		$this->tag_description = __( 'Hubspot Contact Email', 'autonami-automations' );
		add_shortcode( 'bwfan_hubspot_contact_email', array( $this, 'parse_shortcode' ) );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Parse the merge tag and return its value.
	 *
	 * @param $attr
	 *
	 * @return mixed|string|void
	 */
	public function parse_shortcode( $attr ) {
		$email = BWFAN_Merge_Tag_Loader::get_data( 'email' );
		$value = is_email( $email ) ? $email : '';

		return $this->parse_shortcode_output( $value, $attr );
	}

}

/**
 * Register this merge tag to a group.
 */
BWFAN_Merge_Tag_Loader::register( 'hubspot_contact', 'BWFAN_Hubspot_Contact_Email', null, 'Hubspot' );
