<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Create_line_item extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'product_id' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_create_line_item';
	}

	public function process_hubspot_call() {


		$params = [
			"properties"       => [
				"hs_product_id" => $this->data['product_id'],
				"quantity"      => ! empty( $this->data['qty'] ) ? $this->data['qty'] : 1
			],
			'bwfan_con_source' => 'autonami',
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/line_items';
	}

}

return 'WFCO\HubSpot\Create_line_item';
