<?php
#[AllowDynamicProperties]
final class BWFAN_Hubspot_Webhook_Setup {
	private static $instance = null;

	private function __construct() {
		add_action( 'rest_api_init', array( $this, 'bwfan_add_webhook_endpoint' ) );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function bwfan_add_webhook_endpoint() {
		register_rest_route( 'autonami/v1', '/hubspot/webhook(?:/(?P<hubspot_id>\d+))?', array(
			'methods'             => WP_REST_Server::CREATABLE,
			'callback'            => array( $this, 'bwfan_capture_async_events' ),
			'permission_callback' => '__return_true',
			'args'                => [
				'hubspot_id'  => array( 'hubspot_id' => 0 ),
				'hubspot_key' => array( 'hubspot_key' => 0 ),
			],
		) );

		register_rest_route( 'autonami/v1', '/hubspot/webhook(?:/(?P<hubspot_id>\d+))?', array(
			'methods'             => WP_REST_Server::READABLE,
			'callback'            => array( $this, 'bwfan_capture_async_events' ),
			'permission_callback' => '__return_true',
			'args'                => [
				'hubspot_id'  => array( 'hubspot_id' => 0 ),
				'hubspot_key' => array( 'hubspot_key' => 0 ),
			],
		) );
	}

	public function bwfan_capture_async_events( WP_REST_Request $request ) {
		$request_params = $request->get_params();

		//check if url parmas is empty or not
		if ( empty( $request_params ) ) {
			$this->responseToHubspot();
		}

		//check request params contain both the key and id
		if ( ( ! isset( $request_params['hubspot_key'] ) && empty( $request_params['hubspot_key'] ) ) && ( ! isset( $request_params['hubspot_id'] ) && empty( $request_params['hubspot_id'] ) ) ) {
			$this->responseToHubspot();
		}

		//get automation key using automation id
		$automation_id  = $request_params['hubspot_id'];
		$meta           = BWFAN_Model_Automationmeta::get_meta( $automation_id, 'event_meta' );
		$automation_key = $meta['bwfan_unique_key'];

		//check if the automation key exist in database
		if ( empty( $automation_key ) ) {
			$this->responseToHubspot();
		}

		//validate automation key
		if ( $automation_key !== $request_params['hubspot_key'] ) {
			$this->responseToHubspot();
		}

		if ( ! empty( $request_params['is-contact'] ) && ! empty( $request_params['properties'] ) ) {
			do_action( 'bwfan_hubspot_connector_sync_call', $automation_id, $automation_key, $request_params );
		}
		$this->responseToHubspot();
	}

	public function responseToHubspot() {
		wp_send_json( array( 'status' => 'Invalid Hubspot webhook request received' ) );
	}

}

BWFAN_Hubspot_Webhook_Setup::get_instance();
