<?php

namespace WFCO\Keap;

#[\AllowDynamicProperties]
class Create_Contact extends WFCO_Keap_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'access_token', 'email' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_keap_create_contact';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		if ( ! is_email( $this->data['email'] ) ) {
			return array(
				'response' => 502,
				'body'     => array( 'Email is not valid' ),
			);
		}

		\BWFCO_Keap::set_headers( $this->data['access_token'] );

		/** added handling to check first if the contact exists with email as create contact keap call doesn't check for existing contact itself */
		$retrieve_params           = array( 'bwfan_con_source' => 'autonami', 'method' => 'get' );
		$contact_retrieve_endpoint = \BWFCO_Keap::get_endpoint() . 'contacts?email=' . rawurlencode( $this->data['email'] );
		$res                       = $this->make_wp_requests( $contact_retrieve_endpoint, $retrieve_params, \BWFCO_Keap::get_headers(), \BWF_CO::$GET );
		if ( ( is_array( $res ) && isset( $res['response'] ) && 200 === absint( $res['response'] ) ) && ( isset( $res['body']['contacts'] ) && ! empty( $res['body']['contacts'] ) ) ) {
			return $res;
		}

		$params = array(
			'email_addresses'  => array(
				array( 'email' => $this->data['email'], 'field' => 'EMAIL1' )
			),
			'bwfan_con_source' => 'autonami',
		);

		if ( isset( $this->data['first_name'] ) && ! empty( $this->data['first_name'] ) ) {
			$params['given_name'] = $this->data['first_name'];
		}

		if ( isset( $this->data['last_name'] ) && ! empty( $this->data['last_name'] ) ) {
			$params['family_name'] = $this->data['last_name'];
		}

		/** mark contact status as Unconfirmed(marketable) */
		if ( isset( $this->data['mark_status_marketable'] ) && 'yes' === $this->data['mark_status_marketable'] ) {
			$params['opt_in_reason'] = 'Contact gave explicit permission.';
		}

		$res = $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_Keap::get_headers(), \BWF_CO::$POST );

		return $res;
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_Keap::get_endpoint() . 'contacts';
	}

}

return 'WFCO\Keap\Create_Contact';
