<?php

#[AllowDynamicProperties]
class BWFCO_Klaviyo extends BWF_CO {
	public static $api_end_point = 'https://a.klaviyo.com/api/';
	public static $headers = null;
	public static $revision = '2023-07-15';
	private static $ins = null;
	public $v2 = true;

	public function __construct() {
		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->load_commons();

		/** Connector.php initialization */
		$this->keys_to_track = [
			'api_key',
			'lists',
		];
		$this->form_req_keys = [
			'api_key',
		];

		$this->sync          = true;
		$this->connector_url = WFCO_KLAVIYO_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Klaviyo', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Klaviyo_Integration';
		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );
	}

	public function define_plugin_properties() {
		define( 'WFCO_KLAVIYO_VERSION', '1.0.0' );
		define( 'WFCO_KLAVIYO_FULL_NAME', 'FunnelKit Automations Connectors: Klaviyo' );
		define( 'WFCO_KLAVIYO_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_KLAVIYO_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_KLAVIYO_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_KLAVIYO_PLUGIN_FILE ) ) );
		define( 'WFCO_KLAVIYO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_KLAVIYO_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_KLAVIYO_ENCODE', sha1( WFCO_KLAVIYO_PLUGIN_BASENAME ) );
	}

	/**
	 * Load common hooks
	 */
	public function load_commons() {
		require WFCO_KLAVIYO_PLUGIN_DIR . '/includes/class-wfco-klaviyo-call.php';
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function get_headers() {
		return self::$headers;
	}

	public static function set_headers( $data ) {
		$headers = array(
			'Authorization' => 'Klaviyo-API-Key ' . $data['api_key'],
			'Content-Type'  => 'application/json',
			'accept'        => 'application/json',
			'revision'      => self::$revision,

		);

		self::$headers = $headers;
	}

	/**
	 * This function connects to the automation and fetch the data required for the actions on automations screen to work properly.
	 *
	 * @param $data
	 *
	 * @return array|int
	 */
	public function get_api_data( $data ) {
		$resp_array                        = array();
		$resp_array['api_data']['api_key'] = isset( $data['api_key'] ) ? $data['api_key'] : '';
		$resp_array['status']              = 'success';

		if ( ! isset( $data['api_key'] ) || empty( $data['api_key'] ) ) {
			return $resp_array;
		}

		$params = array(
			'api_key'          => $data['api_key'],
			'bwfan_con_source' => 'autonami',
		);

		/** Fetch Lists */
		$lists_result = $this->fetch_lists( $params );
		if ( is_array( $lists_result ) && count( $lists_result ) > 0 && ! isset( $lists_result['status'] ) ) {
			$resp_array['api_data']['lists'] = $lists_result;
		} else {
			$resp_array['status']  = 'failed';
			$resp_array['message'] = isset( $lists_result['message'] ) ? $lists_result['message'] : '';
		}

		return $resp_array;
	}

	/**
	 * Fetch Klaviyo Lists
	 *
	 * @param $params
	 * @param $lists
	 * @param $next_link
	 *
	 * @return array|mixed
	 */
	public function fetch_lists( $params, $lists = [], $next_link = '' ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Klaviyo\Get_Lists $call */
		$call = $connectors->get_call( 'wfco_klaviyo_get_lists' );
		$call->set_data( $params );

		/** Assign next link to API endpoint for fetching next page list*/
		if ( ! empty( $next_link ) ) {
			$call->endpoint = $next_link;
		}
		$result = $call->process();

		if ( 4 === $result['status'] ) {
			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => __( $result['message'], 'autonami-automations-connectors' ),
			);
		}

		$response = isset( $result['payload']['data'] ) ? $result['payload']['data'] : [];
		if ( empty( $response ) ) {
			return [];
		}

		foreach ( $response as $data ) {
			$lists[ $data['id'] ] = $data['attributes']['name'];
		}
		/** Get next link for fetch next page lists */
		$next_link = isset( $result['payload']['links']['next'] ) ? $result['payload']['links']['next'] : null;
		if ( empty( $next_link ) ) {
			return $lists;
		}

		return self::fetch_lists( $params, $lists, $next_link );
	}


	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_klaviyo'] = array(
			'name'            => 'Klaviyo',
			'desc'            => __( 'Add to list, Remove From list and update persons fields.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Klaviyo',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'api_key',
				'label'       => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_klviyo_api_key',
				'placeholder' => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			)
		);
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();

		$vals = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}

		return $vals;
	}
}

WFCO_Load_Connectors::register( 'BWFCO_Klaviyo' );
