<?php

namespace WFCO\Mailchimp;

#[\AllowDynamicProperties]
class Add_To_List extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'email', 'list_id' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mailchimp_add_to_list';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		if ( ! is_email( $this->data['email'] ) ) {
			return array(
				'response' => 502,
				'body'     => array( 'Email is not valid' ),
			);
		}

		// checking for contact and setting status for new only, ignoring for existing one
		$status         = [];
		$contact_exists = \WFCO_Mailchimp_Common::get_contact_by_email( $this->data['api_key'], $this->data['email'], $this->data['list_id'] );
		if ( ! $contact_exists && isset( $this->data['status'] ) ) {
			$status['status_if_new'] = $this->data['status'];
		}

		return \WFCO_Mailchimp_Common::get_contact( $this->data['api_key'], $this->data['list_id'], $this->data['email'], $status );
	}

}

return 'WFCO\Mailchimp\Add_To_List';
