<?php

#[AllowDynamicProperties]
class BWFCO_Mailchimp extends BWF_CO {
	public static $api_end_point = 'https://<dc>.api.mailchimp.com/';
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	public function __construct() {
		/** Setup includes from add-on plugin */
		$this->define_plugin_properties();
		$this->init_mailchimp();

		/** Connector.php initialization */
		$this->keys_to_track = array(
			'api_key',
			'default_list',
			'custom_fields',
			'tags',
			'lists',
		);
		$this->form_req_keys = array(
			'api_key',
			'default_list',
		);

		$this->sync          = true;
		$this->connector_url = WFCO_MAILCHIMP_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Mailchimp', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Mailchimp_Integration';

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );
		add_action( 'wp_ajax_bwf_get_mailchimp_lists', array( $this, 'ajax_get_mailchimp_lists' ) );
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_MAILCHIMP_VERSION', '1.0.0' );
		define( 'WFCO_MAILCHIMP_FULL_NAME', 'FunnelKit Automations Connectors: Mailchimp' );
		define( 'WFCO_MAILCHIMP_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_MAILCHIMP_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_MAILCHIMP_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_MAILCHIMP_PLUGIN_FILE ) ) );
		define( 'WFCO_MAILCHIMP_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_MAILCHIMP_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_MAILCHIMP_ENCODE', sha1( WFCO_MAILCHIMP_PLUGIN_BASENAME ) );
	}

	public function init_mailchimp() {
		require WFCO_MAILCHIMP_PLUGIN_DIR . '/includes/class-wfco-mailchimp-common.php';
		require WFCO_MAILCHIMP_PLUGIN_DIR . '/includes/class-bwfan-mailchimp-webook-setup.php';
	}

	public function ajax_get_mailchimp_lists() {
		BWFAN_Common::check_nonce();

		$api_key                    = isset( $_POST['api_key'] ) ? $_POST['api_key'] : '';
		$params['api_key']          = $api_key;
		$params['bwfan_con_source'] = 'autonami';
		if ( empty( $api_key ) ) {
			wp_send_json( array(
				'response' => __( 'API Key is not provided', 'autonami-automations-connectors' ),
			) );
		}

		$lists_result = $this->fetch_lists( $params );
		if ( ! is_array( $lists_result ) || ! count( $lists_result ) > 0 ) {
			wp_send_json( array( 'status' => false ) );
		}

		wp_send_json( $lists_result );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function get_endpoint( $data_center, $version = '3.0' ) {
		return str_replace( '<dc>', $data_center, self::$api_end_point . $version . '/' );
	}

	public static function get_headers() {
		return self::$headers;
	}

	public static function set_headers( $api_key ) {
		$headers = array(
			'Content-Type'  => 'application/json',
			'Authorization' => 'Basic ' . base64_encode( 'autonami:' . $api_key ),
		);

		self::$headers = $headers;
	}

	public static function get_data_center( $api_key ) {
		if ( empty( $api_key ) || false === strpos( $api_key, '-' ) ) {
			return false;
		}

		return explode( '-', $api_key )[1];
	}

	/**
	 * This function connects to the automation and fetch the data required for the actions on automations screen to work properly.
	 *
	 * @param $posted_data
	 *
	 * @return array|int
	 */
	public function get_api_data( $posted_data ) {
		$resp_array                             = array();
		$resp_array['api_data']['api_key']      = isset( $posted_data['api_key'] ) ? $posted_data['api_key'] : '';
		$resp_array['api_data']['default_list'] = isset( $posted_data['default_list'] ) ? $posted_data['default_list'] : '';
		$resp_array['status']                   = 'success';

		if ( ! isset( $posted_data['api_key'] ) || empty( $posted_data['api_key'] ) ) {
			return $resp_array;
		}

		$params = array(
			'api_key'          => $posted_data['api_key'],
			'list_id'          => $posted_data['default_list'],
			'bwfan_con_source' => 'autonami',
		);

		/** Fetch Custom Fields */
		$custom_fields_result = $this->fetch_custom_fields( $params );
		if ( is_array( $custom_fields_result ) && count( $custom_fields_result ) > 0 ) {
			$resp_array['api_data']['custom_fields'] = $custom_fields_result;
		}

		/** Fetch Tags */
		$tags_result = $this->fetch_tags( $params );
		if ( is_array( $tags_result ) && count( $tags_result ) > 0 ) {
			$resp_array['api_data']['tags'] = $tags_result;
		}

		/** Fetch Lists */
		$lists_result = $this->fetch_lists( $params );
		if ( is_array( $lists_result ) && count( $lists_result ) > 0 ) {
			$resp_array['api_data']['lists'] = $lists_result;
		}
		/** Fetch Automations */
		$automations_result = $this->fetch_automations( $params );
		if ( is_array( $automations_result ) && count( $automations_result ) > 0 ) {
			$resp_array['api_data']['automations'] = $automations_result;
		}

		return $resp_array;
	}


	/**
	 * Fetch Mailchimp Custom Contact Fields
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_custom_fields( $params, $captured_items = array() ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Mautic\Get_Contact_Fields $call */
		$call = $connectors->get_call( 'wfco_mailchimp_get_custom_fields' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Mailchimp Error: ', 'autonami-automations-connectors' );
			$error .= is_array( $result['body'] ) && isset( $result['body']['detail'] ) ? $result['body']['detail'] : __( 'No Response from Mailchimp. ', 'autonami-automations-connectors' );
			$error .= ( 502 === absint( $result['response'] ) ) ? __( 'FunnelKit Automations Error: ', 'autonami-automations-connectors' ) . $result['body'][0] : '';

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		$total_items_count = absint( $result['body']['total_items'] );
		$data              = $result['body']['merge_fields'];
		foreach ( $data as $row ) {
			$captured_items[ $row['tag'] ] = $row['name'];
		}

		$offset = '';
		if ( $total_items_count > count( $captured_items ) ) {
			$offset = count( $captured_items );
		}
		if ( ! empty( $offset ) ) {
			$params['offset'] = $offset;

			return $this->fetch_custom_fields( $params, $captured_items );
		}

		return $captured_items;
	}

	/**
	 * Fetch Mailchimp Tags
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_tags( $params, $captured_items = array() ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Mautic\Get_Contact_Fields $call */
		$call = $connectors->get_call( 'wfco_mailchimp_get_tags' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Mailchimp Error: ', 'autonami-automations-connectors' );
			$error .= is_array( $result['body'] ) && isset( $result['body']['detail'] ) ? $result['body']['detail'] : __( 'No Response from Mailchimp. ', 'autonami-automations-connectors' );
			$error .= ( 502 === absint( $result['response'] ) ) ? __( 'FunnelKit Automations Error: ', 'autonami-automations-connectors' ) . $result['body'][0] : '';

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		$total_items_count = absint( $result['body']['total_items'] );
		$data              = $result['body']['segments'];
		foreach ( $data as $row ) {
			$id                    = $row['id'];
			$captured_items[ $id ] = $row['name'];
		}

		$offset = '';
		if ( $total_items_count > count( $captured_items ) ) {
			$offset = count( $captured_items );
		}
		if ( ! empty( $offset ) ) {
			$params['offset'] = $offset;

			return $this->fetch_tags( $params, $captured_items );
		}

		return $captured_items;
	}

	/**
	 * Fetch Mailchimp Lists
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_lists( $params, $captured_items = array() ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Mautic\Get_Contact_Fields $call */
		$call = $connectors->get_call( 'wfco_mailchimp_get_lists' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Mailchimp Error: ', 'autonami-automations-connectors' );
			$error .= is_array( $result['body'] ) && isset( $result['body']['detail'] ) ? $result['body']['detail'] : __( 'No Response from Mailchimp. ', 'autonami-automations-connectors' );
			$error .= ( 502 === absint( $result['response'] ) ) ? __( 'FunnelKit Automations Error: ', 'autonami-automations-connectors' ) . $result['body'][0] : '';

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		$total_items_count = absint( $result['body']['total_items'] );
		$data              = $result['body']['lists'];
		foreach ( $data as $row ) {
			$id                    = $row['id'];
			$captured_items[ $id ] = $row['name'];
		}

		$offset = '';
		if ( $total_items_count > count( $captured_items ) ) {
			$offset = count( $captured_items );
		}
		if ( ! empty( $offset ) ) {
			$params['offset'] = $offset;

			return $this->fetch_lists( $params, $captured_items );
		}

		return $captured_items;
	}

	/**
	 * Fetch Mailchimp Automations
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_automations( $params, $captured_items = array() ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		$call       = $connectors->get_call( 'wfco_mailchimp_get_automations' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Mailchimp Error: ', 'autonami-automations-connectors' );
			$error .= is_array( $result['body'] ) && isset( $result['body']['detail'] ) ? $result['body']['detail'] : __( 'No Response from Mailchimp. ', 'autonami-automations-connectors' );
			$error .= ( 502 === absint( $result['response'] ) ) ? __( 'FunnelKit Automations Error: ', 'autonami-automations-connectors' ) . $result['body'][0] : '';

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		$total_items_count = absint( $result['body']['total_items'] );
		$data              = $result['body']['automations'];
		foreach ( $data as $row ) {
			$captured_items[ $row['id'] ] = $row['settings']['title'];
		}

		$offset = '';
		if ( $total_items_count > count( $captured_items ) ) {
			$offset = count( $captured_items );
		}
		if ( ! empty( $offset ) ) {
			$params['offset'] = $offset;

			return $this->fetch_automations( $params, $captured_items );
		}

		return $captured_items;
	}

	/**
	 * Fetch Mailchimp Automations Emails
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_automations_email( $params, $captured_items = array() ) {
		$connectors                 = WFCO_Load_Connectors::get_instance();
		$call                       = $connectors->get_call( 'wfco_mailchimp_get_automations_emails' );
		$params['bwfan_con_source'] = 'autonami';
		$call->set_data( $params );

		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Mailchimp Error: ', 'autonami-automations-connectors' );
			$error .= is_array( $result['body'] ) && isset( $result['body']['detail'] ) ? $result['body']['detail'] : __( 'No Response from Mailchimp. ', 'autonami-automations-connectors' );
			$error .= ( 502 === absint( $result['response'] ) ) ? __( 'FunnelKit Automations Error: ', 'autonami-automations-connectors' ) . $result['body'][0] : '';

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		$total_items_count = absint( $result['body']['total_items'] );
		$data              = $result['body']['emails'];
		foreach ( $data as $row ) {
			$captured_items[] = $row['id'];
		}

		$offset = '';
		if ( $total_items_count > count( $captured_items ) ) {
			$offset = count( $captured_items );
		}
		if ( ! empty( $offset ) ) {
			$params['offset'] = $offset;

			return $this->fetch_automations_email( $params, $captured_items );
		}

		return $captured_items;
	}

	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_mailchimp'] = array(
			'name'            => 'Mailchimp',
			'desc'            => __( 'Add or Remove tags, Change contact\'s list, Update merge custom fields and much more.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Mailchimp',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	public function get_initial_schema() {
		return array(
			$this->get_api_key_schema(),
		);
	}

	public function get_fields_schema() {
		$api_key_schema = $this->get_api_key_schema();

		/** Send Only API Key Schema, if only API Key Available */
		$settings = $this->get_settings_fields_values();
		if ( empty( $settings ) || ! isset( $settings['default_list'] ) ) {
			return array( $api_key_schema );
		}

		return array(
			$api_key_schema,
			$this->get_lists_schema_with_old_list_options(),
		);
	}

	public function get_api_key_schema() {
		return array(
			'id'          => 'api_key',
			'type'        => 'text',
			'label'       => __( 'Enter API Key', 'autonami-automations-connectors' ),
			'placeholder' => __( 'Enter API Key', 'autonami-automations-connectors' ),
			'class'       => 'bwfan_mailchimp_api_key',
			'required'    => true,
		);
	}

	public function get_lists_schema_with_old_list_options() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		if ( ! isset( $old_data['lists'] ) || ! is_array( $old_data['lists'] ) ) {
			return array();
		}

		return $this->get_lists_schema( $old_data['lists'] );
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();

		$vals = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}
		if ( isset( $old_data['default_list'] ) ) {
			$vals['default_list'] = $old_data['default_list'];
		}

		return $vals;
	}

	public function get_meta_data() {
		return array(
			'connect_type' => 'wizard',
		);
	}

	/**
	 * Return true means all values are available, Now just run the handle_settings_form
	 */
	public function get_next_step( $values ) {
		if ( empty( $values ) || ! isset( $values['api_key'] ) || empty( $values['api_key'] ) ) {
			return BWFCRM_Common::crm_error( __( 'API Key is not provided', 'autonami-automations-connectors' ) );
		}

		/** Return List options to get list_id */
		if ( ! isset( $values['default_list'] ) || empty( $values['default_list'] ) ) {
			$lists = $this->fetch_lists( $values );
			if ( is_array( $lists ) && isset( $lists['status'] ) && 'failed' === $lists['status'] ) {
				return BWFCRM_Common::crm_error( $lists['message'] );
			}

			if ( ! is_array( $lists ) || 0 === count( $lists ) ) {
				return BWFCRM_Common::crm_error( __( 'No Lists found to select', 'autonami-automations-connectors' ) );
			}

			return array( $this->get_lists_schema( $lists ) );
		}

		return true;
	}

	public function get_lists_schema( $lists ) {
		$options = array(
			array(
				'label' => __( 'Select List', 'autonami-automations-connectors' ),
				'value' => '',
			),
		);
		foreach ( $lists as $id => $name ) {
			$options[] = array(
				'label' => $name,
				'value' => $id,
			);
		}

		return array(
			'id'       => 'default_list',
			'type'     => 'wp_select',
			'label'    => __( 'Select List', 'autonami-automations-connectors' ),
			'class'    => 'bwfan_mailchimp_list_id',
			'required' => true,
			'options'  => $options,
		);
	}

}

WFCO_Load_Connectors::register( 'BWFCO_Mailchimp' );
