<?php

#[AllowDynamicProperties]
class BWFCO_Mailerlite extends BWF_CO {
	public static $api_end_point = 'https://api.mailerlite.com/api/v2/';
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	public function __construct() {
		/** Setup includes from add-on plugin */
		$this->define_plugin_properties();
		$this->init_mailerlite();

		/** Connector.php initialization */
		$this->keys_to_track = [
			'api_key',
			'subscriber_fields',
			'groups',
			'subscribers'
		];
		$this->form_req_keys = [
			'api_key'
		];

		$this->sync          = true;
		$this->connector_url = WFCO_MAILERLITE_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Mailerlite', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Mailerlite_Integration';

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );

		/** Mailerlite uses JSON formatted data as Body */
		add_filter( 'http_request_args', array( $this, 'parse_body_for_mailerlite' ), 999, 2 );
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_MAILERLITE_VERSION', '1.0.0' );
		define( 'WFCO_MAILERLITE_FULL_NAME', 'FunnelKit Automations Connectors: Mailerlite' );
		define( 'WFCO_MAILERLITE_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_MAILERLITE_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_MAILERLITE_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_MAILERLITE_PLUGIN_FILE ) ) );
		define( 'WFCO_MAILERLITE_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_MAILERLITE_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_MAILERLITE_ENCODE', sha1( WFCO_MAILERLITE_PLUGIN_BASENAME ) );
	}

	public function init_mailerlite() {
		require WFCO_MAILERLITE_PLUGIN_DIR . '/includes/class-wfco-mailerlite-call.php';
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function get_headers() {
		return self::$headers;
	}

	public static function set_headers( $api_key ) {
		$headers = array(
			'X-MailerLite-ApiKey' => $api_key,
			'Content-Type'        => 'application/json',
		);

		self::$headers = $headers;
	}

	public function parse_body_for_mailerlite( $args, $url ) {

		if ( empty( $args['body'] ) || false === strpos( $url, 'mailerlite' ) || ! isset( $args['body']['bwfan_con_source'] ) ) {
			return $args;
		}

		/** not encode the body in case of get method */
		unset( $args['body']['bwfan_con_source'] );
		if ( ! empty( $args['body']['method'] ) ) {
			unset( $args['body']['method'] );

			return $args;
		}

		$args['body'] = wp_json_encode( $args['body'] );

		return $args;
	}

	/**
	 * This function connects to the automation and fetch the data required for the actions on automations screen to work properly.
	 *
	 * @param $posted_data
	 *
	 * @return array|int
	 */
	public function get_api_data( $posted_data ) {
		$resp_array                        = array();
		$resp_array['api_data']['api_key'] = isset( $posted_data['api_key'] ) ? $posted_data['api_key'] : '';
		$resp_array['status']              = 'success';

		if ( ! isset( $posted_data['api_key'] ) || empty( $posted_data['api_key'] ) ) {
			return $resp_array;
		}

		$params = array(
			'api_key'          => $posted_data['api_key'],
			'bwfan_con_source' => 'autonami',
		);

		/** Fetch Subscriber Fields */
		$custom_fields_result = $this->fetch_subscriber_fields( $params );

		if ( is_array( $custom_fields_result ) && count( $custom_fields_result ) > 0 && ! isset( $custom_fields_result['status'] ) ) {
			$resp_array['api_data']['subscriber_fields'] = $custom_fields_result;
		} else {
			if ( isset( $custom_fields_result['status'] ) && 'failed' !== $custom_fields_result['status'] ) {
				$resp_array['status']  = 'failed';
				$resp_array['message'] = isset( $custom_fields_result['message'] ) ? $custom_fields_result['message'] : '';
			}
		}

		/** Fetch Groups */
		$tags_result = self::fetch_groups( $params );
		if ( is_array( $tags_result ) && count( $tags_result ) > 0 && ! isset( $custom_fields_result['status'] ) ) {
			$resp_array['api_data']['groups'] = $tags_result;
		} else {
			if ( isset( $tags_result['status'] ) && 'failed' === $tags_result['status'] ) {
				$resp_array['status']  = 'failed';
				$resp_array['message'] = isset( $tags_result['message'] ) ? $tags_result['message'] : '';
			}
		}

		return $resp_array;
	}

	/**
	 * Fetch Mailerlite Custom Contact Fields
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_subscriber_fields( $params ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Mailerlite\Get_Subscriber_Fields $call */
		$call = $connectors->get_call( 'wfco_mailerlite_get_subscriber_fields' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === $result['status'] ) {
			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $result['message'],
			);
		}

		$fields = $result['payload'];

		$subscriber_fields = [];
		foreach ( $fields as $data ) {
			$subscriber_fields[ $data['key'] ] = $data['title'];
		}

		return $subscriber_fields;
	}

	/**
	 * Fetch Mailerlite Groups
	 *
	 * @param $params
	 * @param $all_groups
	 * @param $page
	 *
	 * @return array|mixed
	 */
	public static function fetch_groups( $params, $all_groups = [], $page = 1 ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\MailerLite\Get_Group_List $call */
		$call = $connectors->get_call( 'wfco_mailerlite_get_group_list' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === $result['status'] ) {
			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $result['message'],
			);
		}
		$groups = isset( $result['payload'] ) ? $result['payload'] : [];
		if ( empty( $groups ) ) {
			return $all_groups;
		}
		$captured_groups = [];
		foreach ( $groups as $group ) {
			$captured_groups[ $group['id'] ] = $group['name'];
		}

		if ( 0 === count( $captured_groups ) ) {
			return $all_groups;
		}

		/** If captured group count is less than limit on first page */
		if ( $page === 1 && count( $captured_groups ) < 50 ) {
			return $captured_groups;
		}

		$all_groups = empty( $all_groups ) ? $captured_groups : $all_groups;
		$all_groups = array_replace( $all_groups, $captured_groups );

		/** offset = ( limit * page ) + 1 */
		$offset           = ( 50 * $page ) + 1;
		$params['offset'] = $offset;
		$page ++;

		return self::fetch_groups( $params, $all_groups, $page );
	}


	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_mailerlite'] = array(
			'name'            => 'Mailerlite',
			'desc'            => __( 'Add or Remove tags, Change contact\'s list, Update merge custom fields and much more.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Mailerlite',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'api_key',
				'label'       => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_mailerlite_api_key',
				'placeholder' => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			)
		);
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();

		$vals = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}

		return $vals;
	}
}

WFCO_Load_Connectors::register( 'BWFCO_Mailerlite' );
