<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

#[AllowDynamicProperties]
class WFCO_Mautic_Countries {

	private $countries = null;
	private static $instance = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function __construct() {
		$this->countries = array(
			'Afghanistan'                                => "Afghanistan",
			'&#197;land Islands'                         => "Åland Islands",
			'Albania'                                    => "Albania",
			'Algeria'                                    => "Algeria",
			'American Samoa'                             => "Unknown",
			'Andorra'                                    => "Andorra",
			'Angola'                                     => "Angola",
			'Anguilla'                                   => "Anguilla",
			'Antarctica'                                 => "Antarctica",
			'Antigua and Barbuda'                        => "Antigua and Barbuda",
			'Argentina'                                  => "Argentina",
			'Armenia'                                    => "Armenia",
			'Aruba'                                      => "Aruba",
			'Australia'                                  => "Australia",
			'Austria'                                    => "Austria",
			'Azerbaijan'                                 => "Azerbaijan",
			'Bahamas'                                    => "Bahamas",
			'Bahrain'                                    => "Bahrain",
			'Bangladesh'                                 => "Bangladesh",
			'Barbados'                                   => "Barbados",
			'Belarus'                                    => "Belarus",
			'Belgium'                                    => "Belgium",
			'Belau'                                      => "Unknown",
			'Belize'                                     => "Belize",
			'Benin'                                      => "Benin",
			'Bermuda'                                    => "Bermuda",
			'Bhutan'                                     => "Bhutan",
			'Bolivia'                                    => "Bolivia",
			'Bonaire, Saint Eustatius and Saba'          => "Bonaire, Saint Eustatius and Saba",
			'Bosnia and Herzegovina'                     => "Bosnia and Herzegovina",
			'Botswana'                                   => "Botswana",
			'Bouvet Island'                              => "Bouvet Island",
			'Brazil'                                     => "Brazil",
			'British Indian Ocean Territory'             => "Unknown",
			'Brunei'                                     => "Brunei",
			'Bulgaria'                                   => "Bulgaria",
			'Burkina Faso'                               => "Burkina Faso",
			'Burundi'                                    => "Burundi",
			'Cambodia'                                   => "Cambodia",
			'Cameroon'                                   => "Cameroon",
			'Canada'                                     => "Canada",
			'Cape Verde'                                 => "Unknown",
			'Cayman Islands'                             => "Cayman Islands",
			'Central African Republic'                   => "Central African Republic",
			'Chad'                                       => "Chad",
			'Chile'                                      => "Chile",
			'China'                                      => "China",
			'Christmas Island'                           => "Unknown",
			'Cocos (Keeling) Islands'                    => "Unknown",
			'Colombia'                                   => "Colombia",
			'Comoros'                                    => "Comoros",
			'Congo (Brazzaville)'                        => "Unknown",
			'Congo (Kinshasa)'                           => "Unknown",
			'Cook Islands'                               => "Cook Islands",
			'Costa Rica'                                 => "Costa Rica",
			'Croatia'                                    => "Croatia",
			'Cuba'                                       => "Cuba",
			'Cura&ccedil;ao'                             => "Unknown",
			'Cyprus'                                     => "Cyprus",
			'Czech Republic'                             => "Czech Republic",
			'Denmark'                                    => "Denmark",
			'Djibouti'                                   => "Djibouti",
			'Dominica'                                   => "Dominica",
			'Dominican Republic'                         => "Dominican Republic",
			'Ecuador'                                    => "Ecuador",
			'Egypt'                                      => "Egypt",
			'El Salvador'                                => "El Salvador",
			'Equatorial Guinea'                          => "Equatorial Guinea",
			'Eritrea'                                    => "Eritrea",
			'Estonia'                                    => "Estonia",
			'Ethiopia'                                   => "Ethiopia",
			'Falkland Islands'                           => "Unknown",
			'Faroe Islands'                              => "Unknown",
			'Fiji'                                       => "Fiji",
			'Finland'                                    => "Finland",
			'France'                                     => "France",
			'French Guiana'                              => "French Guiana",
			'French Polynesia'                           => "French Polynesia",
			'French Southern Territories'                => "Unknown",
			'Gabon'                                      => "Gabon",
			'Gambia'                                     => "Gambia",
			'Georgia'                                    => "Georgia",
			'Germany'                                    => "Germany",
			'Ghana'                                      => "Ghana",
			'Gibraltar'                                  => "Gibraltar",
			'Greece'                                     => "Greece",
			'Greenland'                                  => "Greenland",
			'Grenada'                                    => "Grenada",
			'Guadeloupe'                                 => "Guadeloupe",
			'Guam'                                       => "Guam",
			'Guatemala'                                  => "Guatemala",
			'Guernsey'                                   => "Guernsey",
			'Guinea'                                     => "Guinea",
			'Guinea-Bissau'                              => "Guinea Bissau",
			'Guyana'                                     => "Guyana",
			'Haiti'                                      => "Haiti",
			'Heard Island and McDonald Islands'          => "Heard Island and McDonald Islands",
			'Honduras'                                   => "Honduras",
			'Hong Kong'                                  => "Hong Kong",
			'Hungary'                                    => "Hungary",
			'Iceland'                                    => "Iceland",
			'India'                                      => "India",
			'Indonesia'                                  => "Indonesia",
			'Iran'                                       => "Iran",
			'Iraq'                                       => "Iraq",
			'Ireland'                                    => "Ireland",
			'Isle of Man'                                => "Unknown",
			'Israel'                                     => "Israel",
			'Italy'                                      => "Italy",
			'Ivory Coast'                                => "Ivory Coast",
			'Jamaica'                                    => "Jamaica",
			'Japan'                                      => "Japan",
			'Jersey'                                     => "Jersey",
			'Jordan'                                     => "Jordan",
			'Kazakhstan'                                 => "Kazakhstan",
			'Kenya'                                      => "Kenya",
			'Kiribati'                                   => "Kiribati",
			'Kuwait'                                     => "Kuwait",
			'Kyrgyzstan'                                 => "Kyrgyzstan",
			'Laos'                                       => "Laos",
			'Latvia'                                     => "Latvia",
			'Lebanon'                                    => "Lebanon",
			'Lesotho'                                    => "Lesotho",
			'Liberia'                                    => "Liberia",
			'Libya'                                      => "Libya",
			'Liechtenstein'                              => "Liechtenstein",
			'Lithuania'                                  => "Lithuania",
			'Luxembourg'                                 => "Luxembourg",
			'Macao'                                      => "Macao",
			'North Macedonia'                            => "Macedonia",
			'Madagascar'                                 => "Madagascar",
			'Malawi'                                     => "Malawi",
			'Malaysia'                                   => "Malaysia",
			'Maldives'                                   => "Maldives",
			'Mali'                                       => "Mali",
			'Malta'                                      => "Malta",
			'Marshall Islands'                           => "Marshall Islands",
			'Martinique'                                 => "Martinique",
			'Mauritania'                                 => "Mauritania",
			'Mauritius'                                  => "Mauritius",
			'Mayotte'                                    => "Mayotte",
			'Mexico'                                     => "Mexico",
			'Micronesia'                                 => "Micronesia",
			'Moldova'                                    => "Moldova",
			'Monaco'                                     => "Monaco",
			'Mongolia'                                   => "Mongolia",
			'Montenegro'                                 => "Montenegro",
			'Montserrat'                                 => "Montserrat",
			'Morocco'                                    => "Morocco",
			'Mozambique'                                 => "Mozambique",
			'Myanmar'                                    => "Myanmar",
			'Namibia'                                    => "Namibia",
			'Nauru'                                      => "Nauru",
			'Nepal'                                      => "Nepal",
			'Netherlands'                                => "Netherlands",
			'New Caledonia'                              => "New Caledonia",
			'New Zealand'                                => "New Zealand",
			'Nicaragua'                                  => "Nicaragua",
			'Niger'                                      => "Niger",
			'Nigeria'                                    => "Nigeria",
			'Niue'                                       => "Niue",
			'Norfolk Island'                             => "Unknown",
			'Northern Mariana Islands'                   => "Northern Mariana Islands",
			'North Korea'                                => "North Korea",
			'Norway'                                     => "Norway",
			'Oman'                                       => "Oman",
			'Pakistan'                                   => "Pakistan",
			'Palestinian Territory'                      => "Palestine",
			'Panama'                                     => "Panama",
			'Papua New Guinea'                           => "Papua New Guinea",
			'Paraguay'                                   => "Paraguay",
			'Peru'                                       => "Peru",
			'Philippines'                                => "Philippines",
			'Pitcairn'                                   => "Pitcairn",
			'Poland'                                     => "Poland",
			'Portugal'                                   => "Portugal",
			'Puerto Rico'                                => "Puerto Rico",
			'Qatar'                                      => "Qatar",
			'Reunion'                                    => "Réunion",
			'Romania'                                    => "Romania",
			'Russia'                                     => "Russia",
			'Rwanda'                                     => "Rwanda",
			'Saint Barth&eacute;lemy'                    => "Saint Barthelemy",
			'Saint Helena'                               => "Saint Helena, Ascension and Tristan da Cunha",
			'Saint Kitts and Nevis'                      => "Saint Kitts and Nevis",
			'Saint Lucia'                                => "Saint Lucia",
			'Saint Martin (French part)'                 => "Saint Martin",
			'Saint Martin (Dutch part)'                  => "Saint Martin",
			'Saint Pierre and Miquelon'                  => "Saint Pierre and Miquelon",
			'Saint Vincent and the Grenadines'           => "Saint Vincent and the Grenadines",
			'San Marino'                                 => "San Marino",
			'S&atilde;o Tom&eacute; and Pr&iacute;ncipe' => "Sao Tome and Principe",
			'Saudi Arabia'                               => "Saudi Arabia",
			'Senegal'                                    => "Senegal",
			'Serbia'                                     => "Serbia",
			'Seychelles'                                 => "Seychelles",
			'Sierra Leone'                               => "Sierra Leone",
			'Singapore'                                  => "Singapore",
			'Slovakia'                                   => "Slovakia",
			'Slovenia'                                   => "Slovenia",
			'Solomon Islands'                            => "Solomon Islands",
			'Somalia'                                    => "Somalia",
			'South Africa'                               => "South Africa",
			'South Georgia/Sandwich Islands'             => "South Georgia and the South Sandwich Islands",
			'South Korea'                                => "South Korea",
			'South Sudan'                                => "South Sudan",
			'Spain'                                      => "Spain",
			'Sri Lanka'                                  => "Sri Lanka",
			'Sudan'                                      => "Sudan",
			'Suriname'                                   => "Suriname",
			'Svalbard and Jan Mayen'                     => "Svalbard and Jan Mayen",
			'Swaziland'                                  => "Swaziland",
			'Sweden'                                     => "Sweden",
			'Switzerland'                                => "Switzerland",
			'Syria'                                      => "Syria",
			'Taiwan'                                     => "Taiwan",
			'Tajikistan'                                 => "Tajikistan",
			'Tanzania'                                   => "Tanzania",
			'Thailand'                                   => "Thailand",
			'Timor-Leste'                                => "Unknown",
			'Togo'                                       => "Togo",
			'Tokelau'                                    => "Tokelau",
			'Tonga'                                      => "Tonga",
			'Trinidad and Tobago'                        => "Trinidad and Tobago",
			'Tunisia'                                    => "Tunisia",
			'Turkey'                                     => "Turkey",
			'Turkmenistan'                               => "Turkmenistan",
			'Turks and Caicos Islands'                   => "Turks and Caicos Islands",
			'Tuvalu'                                     => "Tuvalu",
			'Uganda'                                     => "Uganda",
			'Ukraine'                                    => "Ukraine",
			'United Arab Emirates'                       => "United Arab Emirates",
			'United Kingdom (UK)'                        => "United Kingdom",
			'United States (US)'                         => "United States",
			'United States (US) Minor Outlying Islands'  => "United States",
			'Uruguay'                                    => "Uruguay",
			'Uzbekistan'                                 => "Uzbekistan",
			'Vanuatu'                                    => "Vanuatu",
			'Vatican'                                    => "Unknown",
			'Venezuela'                                  => "Venezuela",
			'Vietnam'                                    => "Vietnam",
			'Virgin Islands (British)'                   => "Virgin Islands (British)",
			'Virgin Islands (US)'                        => "Virgin Islands (U.S.)",
			'Wallis and Futuna'                          => "Wallis and Futuna",
			'Western Sahara'                             => "Western Sahara",
			'Samoa'                                      => "Unknown",
			'Yemen'                                      => "Yemen",
			'Zambia'                                     => "Zambia",
			'Zimbabwe'                                   => "Zimbabwe"
		);
	}

	public function get_country_by_wc_country( $country ) {
		if ( empty( $country ) ) {
			return false;
		}

		if ( ! isset( $this->countries[ $country ] ) ) {
			return false;
		}

		return $this->countries[ $country ];
	}

	public function get_countries() {
		return $this->countries;
	}

}