<?php

#[AllowDynamicProperties]
class BWFAN_Connector_Rules {

	private static $ins = null;

	private function __construct() {
		add_action( 'bwfan_rules_included', [ $this, 'include_rules' ] );

		add_filter( 'bwfan_rules_groups', [ $this, 'add_rule_group' ] );
		add_filter( 'bwfan_rule_get_rule_types', [ $this, 'add_rule_type' ] );
	}

	public static function get_instance() {
		if ( is_null( self::$ins ) ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	private function get_saved_connectors() {
		$saved_connectors = WFCO_Common::$connectors_saved_data;

		if ( empty( $saved_connectors ) ) {
			WFCO_Common::get_connectors_data();
			$saved_connectors = WFCO_Common::$connectors_saved_data;
		}

		return $saved_connectors;
	}

	public function add_rule_group( $group ) {

		$saved_connectors = $this->get_saved_connectors();

		if ( array_key_exists( 'bwfco_twilio', $saved_connectors ) ) {
			$group['twilio_sms'] = [
				'title' => __( 'Twilio', 'autonami-automations-connectors' ),
			];
		}

		return $group;
	}

	public function add_rule_type( $types ) {

		$saved_connectors = $this->get_saved_connectors();

		if ( array_key_exists( 'bwfco_twilio', $saved_connectors ) ) {
			$types['twilio_sms']['twilio_sms_body_text_match'] = __( 'SMS Body Text Match', 'autonami-automations-connectors' );
		}

		return $types;
	}

	public function include_rules() {

		$saved_connectors = $this->get_saved_connectors();
		if ( array_key_exists( 'bwfco_twilio', $saved_connectors ) ) {
			include_once __DIR__ . '/rules/twilio.php';
		}
	}
}

BWFAN_Connector_Rules::get_instance();
