<?php

namespace WFCO\AC;

#[\AllowDynamicProperties]
class Add_To_List extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'api_url', 'email', 'list_id' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_ac_add_to_list';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		return $this->add_to_list();
	}

	/**
	 * Add contact to list.
	 *
	 * @return array|mixed
	 */
	public function add_to_list() {
		$params_data                                        = $this->data;
		$params_data[ 'p[' . $this->data['list_id'] . ']' ] = $this->data['list_id'];
		$params_data[ 'status[' . $this->data['list_id'] . ']' ] = 1;
		unset( $params_data['list_id'] );
		unset( $params_data['contact_id'] );
		$api_action   = 'contact_sync';
		$endpoint_url = $this->get_endpoint( $this->data['api_key'], $this->data['api_url'], $api_action );

		$result = $this->make_wp_requests( $endpoint_url, $params_data, array(), \BWF_CO::$POST );

		return $result;
	}

	public function get_endpoint( $api_key, $api_url, $api_action ) {
		return \BWFCO_ActiveCampaign::endpoint( $api_key, $api_url, $api_action );
	}

}

return 'WFCO\\AC\\Add_To_List';
