<?php

namespace WFCO\AC;

#[\AllowDynamicProperties]
class Create_Customer extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'api_url', 'connectionid', 'externalid', 'email' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_ac_create_customer';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		\BWFCO_ActiveCampaign::set_headers( $this->data['api_key'] );

		return $this->create_customer();
	}

	/**
	 * Create customer.
	 *
	 * @return array|mixed|object|string
	 */
	public function create_customer() {
		$api_action  = 'ecomCustomers';
		$params_data = array(
			'ecomCustomer' => array(
				'connectionid' => $this->data['connectionid'],
				'externalid'   => $this->data['externalid'],
				'email'        => $this->data['email'],
			),
		);

		$params_data  = wp_json_encode( $params_data );
		$endpoint_url = \BWFCO_ActiveCampaign::get_endpoint_url( $this->data['api_url'], $api_action );
		$result       = $this->make_wp_requests( $endpoint_url, $params_data, \BWFCO_ActiveCampaign::get_headers(), \BWF_CO::$POST );

		return $result;
	}

}

return 'WFCO\\AC\\Create_Customer';
