<?php

namespace WFCO\BulkGate;

#[\AllowDynamicProperties]
class Send_Transactional_Sms extends WFCO_Bulkgate_Call {
	private static $ins = null;
	private $api_url = 'https://portal.bulkgate.com/api/1.0/simple/';

	public function __construct() {
		parent::__construct( array( 'application_id', 'application_token', 'number', 'text' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_bulkgate_send_transactional_sms';
	}

	public function process_bulkgate_call() {
		$params             = array();
		$numbers            = trim( stripslashes( $this->data['number'] ) );
		$numbers            = explode( ',', $numbers );
		$this->data['text'] = apply_filters( 'bwfan_modify_send_sms_body', $this->data['text'], $this->data );

		if ( ! empty( $this->data['sender_id'] ) ) {
			$params['sender_id']       = apply_filters( 'bwfan_modify_bulkgate_sender_profile', 'gText' );
			$params['sender_id_value'] = $this->data['sender_id'];
		}

		$params['application_id']    = $this->data['application_id'];
		$params['application_token'] = $this->data['application_token'];
		$params['text']              = $this->data['text'];

		if ( \BWFAN_Connectors_Common::is_unicode( $this->data['text'] ) ) {
			$params['unicode'] = apply_filters( 'bwfan_bulkgate_unicode', true );
		}

		$res = [];
		foreach ( $numbers as $number ) {
			$params['number'] = $number;
			$res              = $this->do_bulkgate_call( $this->get_end_point(), wp_json_encode( $params ), \BWF_CO::$POST );
		}

		return $res;
	}

	/**
	 * Get API endpoint
	 * If Broadcast then promotional
	 * If Automation, then check if promotional otherwise transactional
	 *
	 * @return string
	 */
	private function get_end_point() {
		/** Set API route to promotional or transactional */
		$endpoint = ( isset( $this->data['promotional_sms'] ) && absint( $this->data['promotional_sms'] ) > 0 ) || ! isset( $this->data['automation_id'] ) ? 'promotional' : 'transactional';

		return $this->api_url . $endpoint;
	}

}

return 'WFCO\\BulkGate\\Send_Transactional_Sms';