<?php

namespace WFCO\BulkGate;

#[\AllowDynamicProperties]
abstract class WFCO_Bulkgate_Call extends \WFCO_Call {
	/**
	 * In case of only api_key, no need to declare the construct in the child call class.
	 * If more than api_key, then use construct and required fields in child call class.
	 *
	 * @param array $required_fields
	 */

	public function __construct( $required_fields = array( 'application_id', 'application_token' ) ) {
		$this->required_fields = $required_fields;
	}

	/** Required fields handling is done here, Also process_bulkgate_call must be implemented in child call class */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->get_autonami_error( $this->show_fields_error()['body'][0] );
		}
		\BWFCO_Bulkgate::set_headers();

		return $this->process_bulkgate_call();
	}

	public function get_autonami_error( $message = false ) {
		BWFAN_Core()->logger->log( $message, 'failed-' . $this->get_slug() . '-action' );

		return array(
			'status'  => 4,
			'message' => ( false !== $message ) ? $message : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' )
		);
	}

	/** Abstract functions that must be present in child's call class */
	abstract function process_bulkgate_call();

	public function do_bulkgate_call( $url, $params, $method ) {
		$response = $this->make_wp_requests( $url, $params, \BWFCO_Bulkgate::get_headers(), $method );

		return $this->handle_api_response( $response );
	}

	/**
	 * Handle API or Autonami Response or Error
	 *
	 * @param array $res
	 *
	 * @return array
	 */
	public function handle_api_response( $res ) {
		/** If success (within 200 status), then return payload (actual response) and status, message */
		if ( ( absint( $res['response'] ) - 200 ) < 100 ) {
			return array(
				'status'  => 3,
				'payload' => $res['body'],
				'message' => __( 'Bulkgate API call executed successfully', 'autonami-automations-connectors' )
			);
		}


		/** If failed, send appropriate error */
		$bulkgate_error = '';
		$response_code  = __( '. Error Response Code: ', 'autonami-automations-connectors' ) . $res['response'];
		if ( isset( $res['body']['error'] ) ) {
			$bulkgate_error = __( 'Bulkgate Error: ', 'autonami-automations-connectors' ) . $res['body']['error'] . ', Code: ' . $res['response'];
		}

		$unknown_error = __( 'Unknown Bulkgate Error', 'autonami-automations-connectors' );

		return array(
			'status'  => 4,
			'message' => ( false !== $bulkgate_error ? $bulkgate_error : $unknown_error ) . $response_code
		);
	}

	public function get_autonami_success( $message = false ) {
		return array(
			'status'  => 3,
			'message' => ( false !== $message ) ? $message : __( 'Task executed successfully!', 'autonami-automations-connectors' )
		);
	}
}