<?php

#[AllowDynamicProperties]
final class BWFAN_DR_Add_Tags extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Add Tags', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds the selected tags to the subscriber', 'autonami-automations-connectors' );
		$this->action_priority = 5;
		$this->support_v2      = true;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'tags_options', $data );
		}
	}

	public function get_view_data() {
		$tags = WFCO_Common::get_single_connector_data( $this->connector, 'tags' );

		return $tags;
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_tags = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'tags')) ? data.actionSavedData.data.tags : {};

            if(_.has(data.actionFieldsOptions, 'tags_options') && _.isObject(data.actionFieldsOptions.tags_options) ) {
            tags_options_clone = data.actionFieldsOptions.tags_options;

            if( _.size(selected_tags) > 0 ) {
            diffTags = _.difference(selected_tags,_.keys(tags_options_clone));

            if(_.size(diffTags) > 0) {
            _.each( diffTags, function( value, key ){
            tags_options_clone[value] = value;
            });

            }
            }
            }
            #>
            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Add Tags', 'autonami-automations-connectors' );
				$message = __( 'Add available tags and if unable to locate then sync the connector.', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
				echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <div class="bwfan_add_tags">
                <div class="bwfan_tags_wrap">
                    <input list="tags" type="text" id="new-tag-bwfan_tag" class="bwfan-input-wrapper" autocomplete="on">
                    <input type="button" class="button bwfan-tag-add" value="Add">
                </div>
                <ul class="tagchecklist" role="list"></ul>
                <select style="display: none" name="bwfan[{{data.action_id}}][data][tags][]" multiple class="bwfan_add_tags_final_value" data-name="tags" data-action="<?php echo $unique_slug ?>">
                </select>
            </div>
        </script>
		<?php
	}

	/**
	 * Overrides the parent class method to return new array type values
	 *
	 * @param $dynamic_array
	 * @param $integration_data
	 *
	 * @return array
	 */
	public function parse_merge_tags( $dynamic_array, $integration_data ) {
		return $this->parse_tags_fields( $dynamic_array, $integration_data );
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$this->is_action_tag         = true;
		$final_tags                  = [];
		$user_input_tags             = $task_meta['data']['tags'];
		$data_to_set                 = array();
		$data_to_set['access_token'] = $integration_object->get_settings( 'access_token' );
		$data_to_set['account_id']   = $integration_object->get_settings( 'account_id' );
		$data_to_set['email']        = $task_meta['global']['email'];

		foreach ( $user_input_tags as $tag_value ) {
			$tags_response = BWFAN_Common::decode_merge_tags( $tag_value );
			$tags          = json_decode( $tags_response );
			if ( is_array( $tags ) && count( $tags ) > 0 ) {
				foreach ( $tags as $single_tag ) {
					$final_tags[] = $single_tag;
				}
				continue;
			}
			$final_tags[] = $tags_response;
		}

		$final_tags          = $this->get_final_tags( $final_tags, $integration_object->get_settings( 'tags' ) );
		$data_to_set['tags'] = array_values( $final_tags );

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                 = array();
		$data_to_set['access_token'] = isset( $step_data['connector_data']['access_token'] ) ? $step_data['connector_data']['access_token'] : '';
		$data_to_set['account_id']   = isset( $step_data['connector_data']['account_id'] ) ? $step_data['connector_data']['account_id'] : '';
		$user_input_tags             = $step_data['tags'];
		$data_to_set['email']        = $automation_data['global']['email'];
		$final_tags                  = [];
		foreach ( $user_input_tags as $tag ) {
			$tag_value     = isset( $tag['id'] ) && empty( absint( $tag['id'] ) ) ? $tag['name'] : $tag['id'];
			$tags_response = BWFAN_Common::decode_merge_tags( $tag_value );

			$final_tags[] = $tags_response;
		}

		$stored_tags = isset( $step_data['connector_data']['tags'] ) ? $step_data['connector_data']['tags'] : [];

		$final_tags          = $this->get_final_tags( $final_tags, $stored_tags );
		$data_to_set['tags'] = array_values( $final_tags );

		return $data_to_set;
	}

	public function get_final_tags( $tags, $stored_tags ) {
		/** If nothing in DB */
		if ( ! isset( $stored_tags ) || ! is_array( $stored_tags ) || empty( $stored_tags ) ) {
			return $tags;
		}

		$tags_to_return = $tags;
		foreach ( $tags as $tag_key => $tag_value ) {
			/** tag value is tag id and is available */
			if ( isset( $stored_tags[ $tag_value ] ) ) {
				unset( $tags_to_return[ $tag_key ] );
				$tags_to_return[] = $stored_tags[ $tag_value ];
			}
		}

		return $tags_to_return;
	}

	/**
	 * Execute the current action.
	 * Return 3 for successful execution , 4 for permanent failure.
	 *
	 * @param $action_data
	 *
	 * @return array
	 */
	public function execute_action( $action_data ) {
		$result = parent::execute_action( $action_data );

		/** handling response in case required field missing **/
		if ( isset( $result['response'] ) && 502 === $result['response'] ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		if ( isset( $result['body']['subscribers'][0]['id'] ) && '' !== $result['body']['subscribers'][0]['id'] ) {
			return array(
				'status'  => 3,
				'message' => 'Tags added successfully',
			);
		}

		return array(
			'status'  => '4',
			'message' => ( isset( $result['body']['errors'][0]['message'] ) ) ? $result['body']['errors'][0]['message'] : WFCO_Common::get_call_object( $this->connector, $this->call )->get_random_api_error(),
		);
	}

	public function before_executing_task() {
		add_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10, 1 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10 );
	}

	public function return_confirmation( $bool ) {
		if ( $this->is_action_tag ) {
			$bool = true;
		}

		return $bool;
	}

	public function handle_response_v2( $result ) {
		/** handling response in case required field missing **/
		if ( isset( $result['response'] ) && 502 === $result['response'] ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		if ( isset( $result['body']['subscribers'][0]['id'] ) && '' !== $result['body']['subscribers'][0]['id'] ) {
			return $this->success_message( __( 'Tags added successfully', 'autonami-automations-connectors' ) );
		}

		return $this->error_response( ( isset( $result['body']['errors'][0]['message'] ) ) ? $result['body']['errors'][0]['message'] : WFCO_Common::get_call_object( $this->connector, $this->call )->get_random_api_error() );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [
			[
				"id"                  => 'tags',
				"label"               => __( 'Add Tags', 'autonami-automations-connectors' ),
				"type"                => 'custom_search',
				'autocompleterOption' => [
					'path'      => 'drip_tags',
					'slug'      => 'drip_tags',
					'labelText' => 'tag'
				],
				"allowFreeTextSearch" => true,
				"required"            => true,
			]
		];
	}

	/**
	 * v2 Methods: Get field options
	 *
	 * @param string $search
	 * @param string $identifier
	 *
	 * @return array|mixed
	 */
	public function get_options( $search = '', $identifier = '' ) {
		$tags = $this->get_view_data();

		if ( empty( $search ) ) {
			return $tags;
		}

		return array_filter( $tags, function ( $tag ) use ( $search ) {
			return false !== strpos( strtolower( $tag ), strtolower( $search ) );
		} );
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['tags'] ) || empty( $data['tags'] ) ) {
			return '';
		}
		$tags = [];
		foreach ( $data['tags'] as $tag ) {
			if ( ! isset( $tag['name'] ) || empty( $tag['name'] ) ) {
				continue;
			}
			$tags[] = $tag['name'];
		}

		return $tags;
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_DR_Add_Tags';
