<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Get_Products extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_get_products';
	}

	public function process_hubspot_call() {
		$params['bwfan_con_source'] = 'autonami';

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( $params, \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		$after = ! empty( $this->data['after'] ) ? $this->data['after'] : '0';

		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/products?limit=10&after=' . $after;
	}

}

return 'WFCO\HubSpot\Get_Products';
