<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Get_Workflows extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_get_workflows';
	}

	public function process_hubspot_call() {
		$params['bwfan_con_source'] = 'autonami';

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( $params, \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'automation/v3/workflows/';
	}

}

return 'WFCO\HubSpot\Get_Workflows';
