<?php

#[AllowDynamicProperties]
final class BWFAN_Mautic_Add_Points extends BWFAN_Action {

	private static $instance = null;

	private function __construct() {
		$this->action_name     = __( 'Add Points to Contact', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds specified points to contact', 'autonami-automations-connectors' );
		$this->action_priority = 50;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_points = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'points')) ? data.actionSavedData.data.points : '';
            #>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Points', 'autonami-automations-connectors' ); ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input min="1" required type="number" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][points]" placeholder="0" value="{{selected_points}}"/>
                <div class="clearfix bwfan_field_desc bwfan-pt-5">
                    Enter the number of points to assign to a contact.
                </div>
            </div>
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set                 = array();
		$data_to_set['site_url']     = $integration_object->get_settings( 'site_url' );
		$data_to_set['access_token'] = $integration_object->get_settings( 'access_token' );
		$data_to_set['points']       = $task_meta['data']['points'];

		/** Set Email if global email is empty */
		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                 = array();
		$data_to_set['site_url']     = isset( $step_data['connector_data']['site_url'] ) ? $step_data['connector_data']['site_url'] : '';
		$data_to_set['access_token'] = isset( $step_data['connector_data']['access_token'] ) ? $step_data['connector_data']['access_token'] : '';
		$data_to_set['points']       = $step_data['points'];
		$data_to_set['email']        = $automation_data['global']['email'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		if ( isset( $result['status'] ) ) {
			return $result;
		}

		if ( isset( $result['body']['success'] ) && $result['body']['success'] ) {
			return array(
				'status'  => 3,
				'message' => __( 'Points added to Contact successfully!', 'autonami-automations-connectors' ),
			);
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$result_message  = ( is_array( $result['body'] ) && isset( $result['body']['errors'] ) ) ? $result['body']['errors'][0]['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return array(
			'status'  => 4,
			'message' => ( false !== $result_message ? $result_message : $unknown_message ) . $response_code,
		);
	}

	public function handle_response_v2( $result ) {

		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		if ( isset( $result['body']['success'] ) && $result['body']['success'] ) {
			return $this->success_message( __( 'Points added to Contact successfully!', 'autonami-automations-connectors' ) );
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$result_message  = ( is_array( $result['body'] ) && isset( $result['body']['errors'] ) ) ? $result['body']['errors'][0]['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return $this->error_response( ( false !== $result_message ? $result_message : $unknown_message ) . $response_code );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [
			[
				'id'          => 'points',
				'label'       => __( "Points", 'autonami-automations-connectors' ),
				'type'        => 'number',
				'placeholder' => "0",
				"class"       => 'bwfan-input-wrapper',
				"description" => '',
				"required"    => true,
			]
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['points'] ) || empty( $data['points'] ) ) {
			return '';
		}

		return $data['points'] . ' ' . __( "Points", 'autonami-automations-connectors' );
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Mautic_Add_Points';
