<?php

namespace WFCO\Twilio;

#[\AllowDynamicProperties]
class Get_Country_Code extends \WFCO_Call {

	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'account_sid', 'auth_token', 'phone' );
		$this->api_end_point   = 'https://lookups.twilio.com/v1/PhoneNumbers/';
	}

	public function get_slug() {
		return "wfco_twilio_get_country_code";
	}

	/**
	 * @return Get_Country_Code|null
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$url     = $this->api_end_point . $this->data['phone'] . '?Type=carrier';
		$headers = array(
			'Content-Type'  => 'application/x-www-form-urlencoded',
			'Authorization' => 'Basic ' . base64_encode( $this->data['account_sid'] . ':' . $this->data['auth_token'] ),
		);

		return $this->make_wp_requests( $url, [], $headers, \BWF_CO::$GET );
	}
}

return 'WFCO\Twilio\Get_Country_Code';
