<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

#[AllowDynamicProperties]
class BWFAN_AC_Automations {
	
	private static $ins = null;
	
	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function get_slug() {
		return 'ac_automations';
	}

	public function get_options( $search ) {
		// BWFAN_AC_Add_To_Automation
		$action = BWFAN_Core()->integration->get_action( 'ac_add_to_automation' );

		if ( ! $action instanceof BWFAN_Action ) {
			return [];
		}

		$data = $action->get_view_data();

		if ( ! method_exists( 'BWFAN_PRO_Common', 'search_srting_from_data' ) ) {
			return [];
		}

		return BWFAN_PRO_Common::search_srting_from_data( $data, $search );
	}

}

if ( class_exists('BWFAN_Load_Custom_Search') ) {
	BWFAN_Load_Custom_Search::register( 'BWFAN_AC_Automations' );
}

