<?php

namespace WFCO\Bitly;

/**
 * Class WFCO_Bitly_Shorten_Url
 */
#[\AllowDynamicProperties]
class Shorten_Url extends \WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'access_token', 'url' );
		$this->api_end_point   = 'https://api-ssl.bitly.com/v4/shorten';
	}

	/**
	 * @return Shorten_Url|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_bitly_shorten_url';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'long_url' => $this->data['url']
		);

		\BWFCO_Bitly::set_headers( $this->data['access_token'] );

		return $this->make_wp_requests( $this->api_end_point, wp_json_encode( $params ), \BWFCO_Bitly::get_headers(), \BWF_CO::$POST );
	}

}

return 'WFCO\Bitly\Shorten_Url';
