<?php

namespace WFCO\BulkGate;

#[\AllowDynamicProperties]
class Oauth_Check extends \WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'application_id', 'application_token' );
		$this->api_end_point   = 'https://portal.bulkgate.com/api/1.0/simple/info';
	}

	/**
	 * @return Oauth_Check|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_bulkgate_oauth_check';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'application_id'    => $this->data['application_id'],
			'application_token' => $this->data['application_token']
		);

		$headers = array();

		return $this->make_wp_requests( $this->api_end_point, $params, $headers, \BWF_CO::$POST );
	}

}

return 'WFCO\\BulkGate\\Oauth_Check';
