<?php

#[AllowDynamicProperties]
final class BWFAN_EverWebinar_Register_Person_To_Webinar extends BWFAN_Action {

	private static $instance = null;

	private function __construct() {
		$this->action_name     = __( 'Register to Webinar (EverWebinar)', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action register a person to everwebinar', 'autonami-automations-connectors' );
		$this->action_priority = 10;
		$this->support_v2      = true;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
		add_action( 'wp_ajax_bwfan_get_everwebinar_schedules', array( $this, 'bwfan_get_everwebinar_schedules' ) );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( ! BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			return;
		}
		$data = $this->get_view_data();
		BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'everwebinar_options', $data );
	}

	/**
	 * get data for view field
	 * @return array
	 */
	public function get_view_data() {
		$webinars = WFCO_Ever_WebinarJam_Common::get_everwebinars();

		if ( ! is_array( $webinars ) || count( $webinars ) === 0 ) {
			return array();
		}
		$array = [];
		foreach ( $webinars as $webinar ) {
			$array[ $webinar['id'] ] = $webinar['text'];
		}

		return $array;
	}

	/**
	 * getting everwebinar schedules against the webinar id received
	 * this is ajax call
	 */
	public function bwfan_get_everwebinar_schedules() {
		$webinar_id = sanitize_text_field( $_POST['id'] ); // WordPress.CSRF.NonceVerification.NoNonceVerification
		$schedules  = [];
		if ( ! empty( $webinar_id ) ) {
			$schedules = WFCO_Ever_WebinarJam_Common::get_everwebinar_schedules( $webinar_id );
		}

		/**call from v2 field schema */
		if ( isset( $_POST['fromApp'] ) && $_POST['fromApp'] ) {
			$finalarr = [];
			foreach ( $schedules as $key => $value ) {
				$finalarr[] = [
					'key'   => $key,
					'value' => $value
				];
			}

			wp_send_json( array(
				'results' => $finalarr
			) );
			exit;
		}

		wp_send_json( array(
			'schedules' => $schedules,
		) );
	}

	/**
	 * creating the action view or form
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script>
            jQuery(document).on('change', '.bwfan-select-everwebinar', function () {
                var webinar_id = jQuery(this).val();
                bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['webinar_id'] = webinar_id;
                if (_.isEmpty(webinar_id)) {
                    jQuery(".bwfan-everwebinar-webinar-schedule").hide();
                    return false;
                }
                jQuery(".bwfan-everwebinar-webinar .bwfan_spinner").removeClass('bwfan_hide');
                jQuery(".bwfan-everwebinar-webinar-schedule").hide();
                jQuery.ajax({
                    method: 'post',
                    url: "<?php echo admin_url( 'admin-ajax.php' ); ?>",
                    datatype: "JSON",
                    data: {
                        action: 'bwfan_get_everwebinar_schedules',
                        id: webinar_id,
                    },
                    success: function (response) {
                        jQuery(".bwfan-everwebinar-webinar .bwfan_spinner").addClass('bwfan_hide');
                        jQuery(".bwfan-everwebinar-webinar-schedule").show();
                        update_everwebinar_webinar_schedules(response.schedules);
                        bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['webinar_schedules'] = response.schedules;
                    }
                });
            });

            function update_everwebinar_webinar_schedules(schedules) {
                var error_generated;
                jQuery("#bwfan-everwebinar_webinar_schedule").html('');
                var option = '<option value="">none</option>';

                if (_.size(schedules) > 0 && _.isObject(schedules)) {
                    _.each(schedules, function (v, e) {
                        option += '<option value="' + e + '">' + v + '</option>';
                    });
                } else {
                    error_generated = jQuery('.bwfan-select-everwebinar').parent().find('div.error.wfco_error').html();
                    if ('undefined' == typeof error_generated) {
                        jQuery('.bwfan-select-everwebinar').after("<div class='error wfco_error'></div>");
                    }
                    jQuery('.error.wfco_error').fadeIn().html('<?php echo __( 'This webinar is not scheduled. Please Select another one', 'autonami-automations-connectors' ); ?>');
                    setTimeout(function () {
                        jQuery('.error.wfco_error').fadeOut("slow");
                    }, 3500);

                    return;
                }
                jQuery('#bwfan-everwebinar_webinar_schedule').parent().find('.bwfan_fetched_webinar_schedules').val(JSON.stringify(schedules));
                jQuery("#bwfan-everwebinar_webinar_schedule").html(option);
            }
        </script>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_event_src = BWFAN_Auto.uiDataDetail.trigger.source;
            selected_event = BWFAN_Auto.uiDataDetail.trigger.event;

            ae = bwfan_automation_data.all_triggers_events;
            email_merge_tag ='';
            if(_.has(ae, selected_event_src) &&
            _.has(ae[selected_event_src], selected_event) &&
            _.has(ae[selected_event_src][selected_event], 'customer_email_tag')) {
            email_merge_tag = ae[selected_event_src][selected_event].customer_email_tag;
            }

            first_name = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'first_name')) ? data.actionSavedData.data.first_name : '';
            last_name = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'last_name')) ? data.actionSavedData.data.last_name : '';
            email = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'email')) ? data.actionSavedData.data.email : email_merge_tag;
            phone = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'phone')) ? data.actionSavedData.data.phone : '';
            #>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'First Name', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][first_name]" placeholder="First Name" value="{{first_name}}"/>
            </div>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Last Name', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][last_name]" placeholder="Last Name" value="{{last_name}}"/>
            </div>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Email', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][email]" placeholder="Email" value="{{email}}"/>
            </div>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Phone', 'autonami-automations-connectors' );
				$message = __( 'Optional', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'top' ); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][phone]" placeholder="Phone" value="{{phone}}"/>
            </div>

            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Select Webinar', 'autonami-automations-connectors' );
				$message = __( 'Select Webinar in which a person will be registered and if unable to locate then sync the connector. Also make sure that you have created the webinar in the webinarjam', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'top' ); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <select required id="" class="bwfan-input-wrapper bwfan-single-select bwfan-select-everwebinar" name="bwfan[{{data.action_id}}][data][webinar_id]">
                <option value=""><?php echo esc_html__( 'Choose Webinar', 'autonami-automations-connectors' ); ?></option>
                <#
                selected_webinar_id = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'webinar_id')) ? data.actionSavedData.data.webinar_id : '';

                if(_.has(data.actionFieldsOptions, 'everwebinar_options') && _.isObject(data.actionFieldsOptions.everwebinar_options) ) {
                everwebinar_options = data.actionFieldsOptions.everwebinar_options;
                #>
                <#
                _.each( everwebinar_options, function( value, key ){
                selected = (key == selected_webinar_id) ? 'selected' : '';
                #>
                <option value="{{key}}" {{selected}}> {{value}}</option>
                <# })
                #>
                <#
                }
                #>
            </select>

            <#
            show_schedules = !_.isEmpty(selected_webinar_id)?'block':'none';
            #>
            <div class="bwfan-everwebinar-webinar bwfan-col-sm-12 bwfan-p-0 bwfan-mt-5">
                <div class="bwfan_spinner bwfan_hide"></div>
                <div class="bwfan-col-sm-12 bwfan-p-0 bwfan-everwebinar-webinar-schedule" style="display:{{show_schedules}}">
                    <label for="" class="bwfan-label-title">
						<?php
						echo esc_html__( 'Select Schedule', 'autonami-automations-connectors' );
						?>
                    </label>
                    <select required id="bwfan-everwebinar_webinar_schedule" class="bwfan-input-wrapper" name="bwfan[{{data.action_id}}][data][schedule]">
                        <option value=""><?php echo esc_html__( 'Choose Schedule', 'autonami-automations-connectors' ); ?></option>
                        <#
                        fetched_schedules = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'fetched_schedules')) ? data.actionSavedData.data.fetched_schedules : '';
                        selected_schedule = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'schedule')) ? data.actionSavedData.data.schedule : '';

                        if(_.size(fetched_schedules) >0) {
                        temp_fetched_schedules = JSON.parse(fetched_schedules);
                        _.each( temp_fetched_schedules, function( value, key ){
                        selected = (key == selected_schedule) ? 'selected' : '';
                        #>
                        <option value="{{key}}" {{selected}}>{{value}}</option>
                        <#
                        })
                        }
                        #>
                    </select>
                    <input type="hidden" class="bwfan_fetched_webinar_schedules" name="bwfan[{{data.action_id}}][data][fetched_schedules]" value="{{fetched_schedules}}"/>
                </div>
            </div>
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set               = array();
		$data_to_set['api_key']    = $integration_object->get_settings( 'api_key' );
		$data_to_set['first_name'] = BWFAN_Common::decode_merge_tags( $task_meta['data']['first_name'] );
		$data_to_set['last_name']  = BWFAN_Common::decode_merge_tags( $task_meta['data']['last_name'] );
		$data_to_set['email']      = BWFAN_Common::decode_merge_tags( $task_meta['data']['email'] );
		$data_to_set['phone']      = BWFAN_Common::decode_merge_tags( $task_meta['data']['phone'] );
		$data_to_set['webinar_id'] = $task_meta['data']['webinar_id'];
		$data_to_set['schedule']   = $task_meta['data']['schedule'];

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set               = array();
		$data_to_set['api_key']    = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['first_name'] = BWFAN_Common::decode_merge_tags( $step_data['first_name'] );
		$data_to_set['last_name']  = BWFAN_Common::decode_merge_tags( $step_data['last_name'] );
		$data_to_set['email']      = BWFAN_Common::decode_merge_tags( $step_data['email'] );
		$data_to_set['phone']      = BWFAN_Common::decode_merge_tags( $step_data['phone'] );
		$data_to_set['webinar_id'] = $step_data['webinar_id'];
		$data_to_set['schedule']   = $step_data['schedule'];

		return $data_to_set;
	}

	/**
	 * @param $result
	 * @param null $call_object
	 * handing response received from api call
	 *
	 * @return array
	 */
	protected function handle_response( $result, $call_object = null ) {

		if ( is_array( $result ) && 200 === $result['response'] ) {
			return array(
				'status'  => 3,
				'message' => __( 'Person registered successfully!', 'autonami-automations-connectors' ),
			);
		}

		if ( 500 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		if ( 401 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body']['errors']['message'] ) ? $result['body']['errors']['message'] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'] ) ? $result['body'] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return array(
			'status'  => 4,
			'message' => $unknown_message . $response_code,
		);
	}

	public function handle_response_v2( $result ) {
		if ( is_array( $result ) && 200 === $result['response'] ) {

			// updating last meeting link
			WFCO_Ever_WebinarJam_Common::update_last_meeting_link( $result );

			return $this->success_message( __( 'Person registered successfully!', 'autonami-automations-connectors' ) );
		}

		if ( 500 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		if ( 401 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body']['errors']['message'] ) ? $result['body']['errors']['message'] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'] ) ? $result['body'] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return $this->error_response( $unknown_message . $response_code );
	}


	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$webinar = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );

		return [
			[
				'id'          => 'first_name',
				'label'       => __( "First Name", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "First Name",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => false,
			],
			[
				'id'          => 'last_name',
				'label'       => __( "Last Name", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "Last Name",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => false,
			],
			[
				'id'          => 'email',
				'label'       => __( "Email", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "Email",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'phone',
				'label'       => __( "Phone", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "Phone",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => false,
			],
			[
				'id'          => 'webinar_id',
				'label'       => __( "Select Webinar", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $webinar,
				'placeholder' => "Choose A Webinar",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'schedule',
				'type'        => 'ajax',
				'label'       => __( 'Select Schedule', 'autonami-automations-connectors' ),
				"class"       => 'bwfan-input-wrapper',
				"required"    => false,
				'placeholder' => 'Select',
				"description" => "",
				"ajax_cb"     => 'bwfan_get_everwebinar_schedules',
				"ajax_field"  => [
					'id' => 'webinar_id'
				],
				"toggler"     => [
					'fields'   => array(
						array(
							'id'    => 'webinar_id',
							'value' => '',
						),
					),
					'relation' => 'AND',
				]
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['webinar_id'] ) || empty( $data['webinar_id'] ) ) {
			return '';
		}

		$webinars = $this->get_view_data();

		if ( ! isset( $webinars[ $data['webinar_id'] ] ) || empty( $webinars[ $data['webinar_id'] ] ) ) {
			return '';
		}

		return $webinars[ $data['webinar_id'] ];
	}

}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_EverWebinar_Register_Person_To_Webinar';
