<?php

#[AllowDynamicProperties]
class WFCO_Ever_WebinarJam_Common {

	private static $instance = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get EverWebinarJam Saved Settings
	 *
	 * @return array
	 */
	public static function get_ever_webinarjam_settings() {
		if ( false === WFCO_Common::$saved_data ) {
			WFCO_Common::get_connectors_data();
		}
		$data = WFCO_Common::$connectors_saved_data;
		$slug = self::get_connector_slug();
		$data = ( isset( $data[ $slug ] ) && is_array( $data[ $slug ] ) ) ? $data[ $slug ] : array();

		return $data;
	}

	/**
	 * getting connector slug
	 * @return string
	 */
	public static function get_connector_slug() {
		return sanitize_title( BWFCO_Ever_WebinarJam::class );
	}

	/**
	 * @param array $settings
	 * update connector settings
	 *
	 * @return bool
	 */
	public static function update_settings( $settings = array() ) {
		if ( empty( $settings ) ) {
			return false;
		}

		$old_settings = self::get_ever_webinarjam_settings();
		$settings     = array_merge( $old_settings, $settings );

		$active_connectors = WFCO_Load_Connectors::get_active_connectors();
		/** @var BWF_CO $connector_ins */
		$connector_ins = $active_connectors[ self::get_connector_slug() ];
		$response      = $connector_ins->handle_settings_form( $settings, 'update' );

		return is_array( $response ) && $response['status'] === 'success' ? true : false;
	}

	/**
	 * Get WebinarJam Webinars
	 *
	 * @return array|string
	 */
	public static function get_webinars() {
		$data = self::get_ever_webinarjam_settings();

		if ( ! isset( $data['api_key'] ) ) {
			return '';
		}

		$results = array();
		if ( ! empty( $data['webinars'] ) ) {
			foreach ( $data['webinars'] as $webinars ) {
				$results[] = array(
					'id'   => $webinars['webinar_id'],
					'text' => $webinars['name'],
				);
			}
		}

		return $results;
	}

	/**
	 * @param $webinar_id
	 * get webinar schedules
	 *
	 * @return array
	 */
	public static function get_webinarjam_schedules( $webinar_id ) {
		$data = self::get_ever_webinarjam_settings();

		$connector = WFCO_Load_Connectors::get_instance();

		$params = array(
			'api_key'    => $data['api_key'],
			'webinar_id' => $webinar_id
		);

		$call = $connector->get_call( 'wfco_webinarjam_get_schedules' );
		$call->set_data( $params );
		$webinar_detail = $call->process();

		$response = [];
		if ( is_array( $webinar_detail ) && 200 === $webinar_detail['response'] ) {
			if ( count( $webinar_detail['body']['webinar']['schedules'] ) === 0 ) {
				return $response;
			}

			foreach ( $webinar_detail['body']['webinar']['schedules'] as $schedules ) {
				$response[ $schedules['schedule'] ] = $schedules['comment'];
			}

		}

		return $response;
	}

	/**
	 * Get EverWebinar Webinars
	 * @return array|string
	 */
	public static function get_everwebinars() {
		$data = self::get_ever_webinarjam_settings();

		if ( ! isset( $data['api_key'] ) ) {
			return '';
		}

		$results = array();
		if ( ! empty( $data['ever_webinars'] ) ) {
			foreach ( $data['ever_webinars'] as $webinars ) {
				$results[] = array(
					'id'   => $webinars['webinar_id'],
					'text' => $webinars['name'],
				);
			}
		}

		return $results;
	}

	/**
	 * @param $webinar_id
	 * get everwebinar schedules
	 *
	 * @return array
	 */
	public static function get_everwebinar_schedules( $webinar_id ) {
		$data = self::get_ever_webinarjam_settings();

		$connector = WFCO_Load_Connectors::get_instance();

		$params = array(
			'api_key'    => $data['api_key'],
			'webinar_id' => $webinar_id
		);

		$call = $connector->get_call( 'wfco_everwebinar_get_schedules' );
		$call->set_data( $params );
		$webinar_detail = $call->process();

		$response = [];
		if ( is_array( $webinar_detail ) && 200 === $webinar_detail['response'] ) {
			if ( count( $webinar_detail['body']['webinar']['schedules'] ) === 0 ) {
				return $response;
			}

			foreach ( $webinar_detail['body']['webinar']['schedules'] as $schedules ) {
				$response[ $schedules['schedule'] ] = $schedules['comment'];
			}

		}

		return $response;
	}

	/**
	 * updating last meeting link field for the user
	 *
	 * @param $result
	 *
	 * @return void
	 */
	public static function update_last_meeting_link( $result ) {
		if ( ! isset( $result['body'] ) || empty( $result['body'] ) || ! isset( $result['body']['user'] ) || empty( $result['body']['user'] ) ) {
			return;
		}

		if ( ! isset( $result['body']['user']['email'] ) || empty( $result['body']['user']['email'] ) || ! isset( $result['body']['user']['live_room_url'] ) || empty( $result['body']['user']['live_room_url'] ) ) {
			return;
		}

		// create contact if not exists
		$contact = new BWFCRM_Contact( $result['body']['user']['email'], true );
		if ( ! $contact->is_contact_exists() ) {
			return;
		}

		$last_meeting_link = BWFCRM_Fields::get_field_id_by_slug( 'last-meeting-link' );

		// if not exists then create field - Last meeting Link.
		if ( ! $last_meeting_link ) {
			$field = BWFCRM_Fields::add_field( 'Last Meeting Link', 1, [], 'Last Meeting Link', 1, 1, 1, '0' );

			if ( ! isset( $field['ID'] ) ) {
				return;
			}

			$last_meeting_link = $field['ID'];
		}

		$contact->update_custom_fields( array( $last_meeting_link => $result['body']['user']['live_room_url'] ) );
	}

}

WFCO_Ever_WebinarJam_Common::get_instance();
