<?php

namespace WFCO\GoogleSheet;

#[\AllowDynamicProperties]
class Get_Worksheets extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {

		$this->required_fields = array( 'spreadsheet_id' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gs_get_worksheets';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$client = \BWFCO_Google_Sheets::get_google_client();
		if ( false === $client ) {
			return false;
		}
		$service = new \Google_Service_BWFSheets( $client );

		try {
			$sheets = $service->spreadsheets->get( $this->data['spreadsheet_id'] )->getSheets();
		} catch ( \Exception $exception ) {
			$errors = $exception->getErrors();

			return array(
				0 => $exception->getCode(),
				1 => $errors[0]['message'],
				3 => false,
			);
		}

		$worksheets    = array();
		$sheets_column = array();
		foreach ( $sheets as $obj ) {
			$sheet_simple_objects                     = $obj->toSimpleObject();
			$sheet_column_count                       = $sheet_simple_objects->properties->gridProperties['columnCount'];
			$sheets_column[ $obj->properties->title ] = $this->get_sheet_column_details( $sheet_column_count );
			$worksheets[ $obj->properties->sheetId ]  = $obj->properties->title;
		}

		return array( 'sheets_column' => $sheets_column, 'worksheets' => $worksheets );

	}

	/** getting sheet column details using sheet column count
	 *
	 * @param $number
	 *
	 * @return array
	 */
	public function get_sheet_column_details( $number ) {
		$column_data = array();
		for ( $i = 0; $i <= $number; $i ++ ) {
			$column_name                 = $this->num2alpha( $i );
			$column_data[ $column_name ] = $column_name;
		}

		return $column_data;
	}

	/** converting number to alphabet
	 *
	 * @param $n
	 *
	 * @return string
	 */
	public function num2alpha( $n ) {
		$r = '';
		for ( $i = 1; $n >= 0 && $i < 10; $i ++ ) {
			$r = chr( 0x41 + ( $n % pow( 26, $i ) / pow( 26, $i - 1 ) ) ) . $r;
			$n -= pow( 26, $i );
		}

		return $r;
	}


}

return 'WFCO\GoogleSheet\Get_Worksheets';
