<?php

namespace WFCO\GoogleSheet;

#[\AllowDynamicProperties]
class Update_Data extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {

		$this->required_fields = array( 'spreadsheet_id', 'worksheet_title', 'worksheet_search_data', 'worksheet_data' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gs_update_data';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$client = \BWFCO_Google_Sheets::get_google_client();
		if ( is_null( $client ) ) {
			return false;
		}

		$service = new \Google_Service_BWFSheets( $client );
		$range   = $this->data['worksheet_title'] . '!' . $this->data['worksheet_search_data']['key'] . '1:' . $this->data['worksheet_search_data']['key'];

		try {
			$response = $service->spreadsheets_values->get( $this->data['spreadsheet_id'], $range );
		} catch ( \Exception $exception ) {
			$errors = $exception->getErrors();

			return array(
				0 => $exception->getCode(),
				1 => $errors[0]['message'],
			);
		}

		$get_values   = $response->getValues();
		/** If it doesn't found the values */
		if ( empty( $get_values ) ) {
			return array( 'status' => 4, 'message' => 'Unbale to find column with value: ' . $this->data['worksheet_search_data']['value'] );
		}
		$lookup_value = $this->data['worksheet_search_data']['value'];

		$get_keys = array_keys( array_filter( $get_values, function ( $values ) use ( $lookup_value ) {
			return $values[0] === $lookup_value;
		} ) );

		$udpate_rows = array_map( function ( $row ) {
			return intval( $row ) + 1;
		}, $get_keys );

		// if update row found then disable for addition of row
		$insert_row = ! empty( $udpate_rows ) ? false : true;

		/** insert row in case search data not found in column */
		if ( 1 === absint( $this->data['enable_insert_row'] ) && true === $insert_row ) {
			$range = $this->data['worksheet_title'];
			/** getting the last row of the sheet to append data properly on sheet */

			$insert_column_values = array();
			$all_columns          = is_array( $this->data['worksheet_column'] ) && count( $this->data['worksheet_column'] ) > 0 ? $this->data['worksheet_column'] : $this->get_all_columns();
			foreach ( $all_columns as $column ) {
				if ( array_key_exists( $column, $this->data['worksheet_data'] ) && ! empty( $this->data['worksheet_data'][ $column ] ) ) {
					$insert_column_values[] = $this->data['worksheet_data'][ $column ];
				} else {
					$insert_column_values[] = '';
				}
			}

			$values = array( $insert_column_values );

			$body   = new \Google_Service_Sheets_BWFValueRange( array(
				'values' => $values,
			) );
			$params = array(
				'valueInputOption' => 'USER_ENTERED',
			);

			try {
				$service->spreadsheets_values->append( $this->data['spreadsheet_id'], $range, $body, $params );
			} catch ( \Exception $exception ) {
				$errors = $exception->getErrors();

				return array(
					0 => $exception->getCode(),
					1 => $errors[0]['message'],
				);
			}

			return true;
		}

		/** if doesn't found the search row then return */
		if ( empty( $udpate_rows ) ) {
			return array( 'status' => 4, 'message' => 'Unbale to find column with value: ' . $this->data['worksheet_search_data']['value'] );
		}

		$values = array();
		foreach ( $this->data['worksheet_data'] as $key => $val ) {
			foreach ( $udpate_rows as $row ) {
				$values[] = array(
					'range'          => $this->data['worksheet_title'] . '!' . $key . $row,
					'majorDimension' => 'ROWS',
					'values'         => array( array( $val ) ),
				);
			}
		}

		$body = new \Google_Service_Sheets_BWFBatchUpdateValuesRequest( array(
			'valueInputOption' => 'USER_ENTERED',
			'data'             => $values,
		) );

		try {
			$service->spreadsheets_values->batchUpdate( $this->data['spreadsheet_id'], $body, array() );
		} catch ( \Exception $exception ) {
			$errors = $exception->getErrors();
			return array(
				0 => $exception->getCode(),
				1 => $errors[0]['message'],
			);
		}

		return true;
	}

	public function get_all_columns() {
		return array(
			'A' => 'A',
			'B' => 'B',
			'C' => 'C',
			'D' => 'D',
			'E' => 'E',
			'F' => 'F',
			'G' => 'G',
			'H' => 'H',
			'I' => 'I',
			'J' => 'J',
			'K' => 'K',
			'L' => 'L',
			'M' => 'M',
			'N' => 'N',
			'O' => 'O',
			'P' => 'P',
			'Q' => 'Q',
			'R' => 'R',
			'S' => 'S',
			'T' => 'T',
			'U' => 'U',
			'V' => 'V',
			'W' => 'W',
			'X' => 'X',
			'Y' => 'Y',
			'Z' => 'Z',
		);
	}


}

return 'WFCO\GoogleSheet\Update_Data';
