<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Add_Contact_To_List extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'email', 'list_id' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_add_contact_to_list';
	}

	public function process_hubspot_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$contact_id = $this->get_contact_by_email();

		if ( empty( $contact_id ) ) {
			$contact = $this->create_contact();
			if ( 4 == $contact['status'] ) {
				return $this->get_autonami_error( $contact['message'] );
			}
			$contact_id = $contact['payload']['id'];
		}

		$params = [
			"vids"             => [ $contact_id ],
			'bwfan_con_source' => 'autonami',
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'contacts/v1/lists/' . $this->data['list_id'] . '/add';
	}

}

return 'WFCO\HubSpot\Add_Contact_To_List';
