<?php

namespace WFCO\Mailchimp;

#[\AllowDynamicProperties]
class Get_Lists extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'api_key' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mailchimp_get_lists';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		\BWFCO_Mailchimp::set_headers( $this->data['api_key'] );
		$params = array( 'bwfan_con_source' => 'autonami' );
		$res    = $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_Mailchimp::get_headers(), \BWF_CO::$GET );

		return $res;
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		$args = [];
		if ( isset( $this->data['offset'] ) && 0 < absint( $this->data['offset'] ) ) {
			$args['offset'] = absint( $this->data['offset'] );
		}

		if ( isset( $this->data['limit'] ) && 0 < absint( $this->data['limit'] ) ) {
			$args['count'] = $this->data['limit'];
		}

		$data_center = \BWFCO_Mailchimp::get_data_center( $this->data['api_key'] );

		return add_query_arg( $args, \BWFCO_Mailchimp::get_endpoint( $data_center ) . 'lists' );
	}

}

return 'WFCO\Mailchimp\Get_Lists';
