<?php

namespace WFCO\Mautic;

#[\AllowDynamicProperties]
class Get_Tags extends WFCO_Mautic_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'site_url', 'access_token' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mautic_get_tags';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'search'         => isset( $this->data['search'] ) ? $params['search'] = $this->data['search'] : null,
			'start'          => isset( $this->data['start'] ) ? $params['start'] = absint( $this->data['start'] ) : null,
			'order_by'       => isset( $this->data['order_by'] ) ? $params['orderBy'] = $this->data['order_by'] : null,
			'limit'          => isset( $this->data['limit'] ) ? $params['limit'] = absint( $this->data['limit'] ) : null,
			'order_by_dir'   => isset( $this->data['order_by_dir'] ) ? $params['orderByDir'] = 'desc' === $this->data['order_by_dir'] ? 'desc' : 'asc' : null,
			'published_only' => isset( $this->data['published_only'] ) ? $params['publishedOnly'] = false === $this->data['published_only'] ? false : true : null,
			'minimal'        => isset( $this->data['minimal'] ) ? $params['minimal'] = false === $this->data['minimal'] ? false : true : null
		);

		return $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_Mautic::get_headers(), \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return rtrim( $this->data['site_url'], '/' ) . '/api/tags?access_token=' . $this->data['access_token'];
	}

}

return 'WFCO\Mautic\Get_Tags';
