<?php
/**
  * Plugin Name: FunnelKit Automations Connectors - Wabot
 * Plugin URI: https://funnelkit.com/wordpress-marketing-automation-autonami/
 * Description: Send WhatsApp messages on abandoned users, post-purchase followups, updates and broadcasts. Works with Autonami Marketing Automations for WordPress
 * Version: 2.2.1
 * Author: WooFunnels
 * Author URI: https://funnelkit.com
 * License: GPLv3 or later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain: autonami-automations-connectors
 *
 * Requires at least: 5.0
 * Tested up to: 5.7.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

final class WFCO_Wabot {
	/**
	 * @var WFCO_Wabot
	 */

	public static $_instance = null;

	private function __construct() {
		$this->sync = true;

		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->load_commons();
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_WABOT_VERSION', '2.2.1' );
		define( 'WFCO_WABOT_FULL_NAME', 'Autonami Marketing Automations Connectors: Wabot' );
		define( 'WFCO_WABOT_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_WABOT_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_WABOT_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_WABOT_PLUGIN_FILE ) ) );
		define( 'WFCO_WABOT_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_WABOT_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_WABOT_ENCODE', sha1( WFCO_WABOT_PLUGIN_BASENAME ) );
	}

	/**
	 * Load common hooks
	 */
	public function load_commons() {
		$this->load_hooks();
	}

	public function load_hooks() {
		add_action( 'wfco_load_connectors', [ $this, 'load_connector_classes' ] );
		add_action( 'bwfan_automations_loaded', [ $this, 'load_autonami_classes' ] );
		add_action( 'bwfan_loaded', [ $this, 'init_wabot' ] );
	}

	public function init_wabot() {
		require WFCO_WABOT_PLUGIN_DIR . '/includes/class-wfco-wabot-call.php';
	}

	public static function get_instance() {
		if ( null === self::$_instance ) {
			self::$_instance = new self;
		}

		return self::$_instance;
	}

	/**
	 * Load Connector Classes
	 */
	public function load_connector_classes() {
		require_once( WFCO_WABOT_PLUGIN_DIR . '/includes/class-wfco-wabot-call.php' );
		require_once( WFCO_WABOT_PLUGIN_DIR . '/connector.php' );

		do_action( 'wfco_wabot_connector_loaded', $this );
	}

	/**
	 * Load Autonami Integration classes
	 */
	public function load_autonami_classes() {
		$integration_dir = WFCO_WABOT_PLUGIN_DIR . '/autonami';
		foreach ( glob( $integration_dir . '/class-*.php' ) as $_field_filename ) {
			require_once( $_field_filename );
		}
		do_action( 'wfco_wabot_integrations_loaded', $this );

	}
}

if ( ! function_exists( 'WFCO_Wabot_Core' ) ) {

	/**
	 * Global Common function to load all the classes
	 * @return WFCO_Wabot
	 */
	function WFCO_Wabot_Core() {  //@codingStandardsIgnoreLine
		return WFCO_Wabot::get_instance();
	}
}

WFCO_Wabot_Core();