<?php
/**
 * BWFCRM_Email_Webhook_Base Abstract Class
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Email_Webhook_Base
 *
 */
abstract class BWFCRM_Email_Webhook_Base {
	protected $_data = [];
	protected $_name = "";

	public function set_data( $data = [] ) {
		$this->_data = $data;
	}

	public function get_name() {
		return $this->_name;
	}

	abstract public function handle_webhook();

	protected function mark_contact_bounce( $contact_email ) {
		if ( ! is_email( $contact_email ) ) {
			BWFAN_Core()->logger->log( 'Unable to bounce contact: Incorrect Email', 'crm_email_webhooks' );

			return;
		}

		$contact = new BWFCRM_Contact( $contact_email );
		if ( ! $contact->mark_as_bounced() ) {
			BWFAN_Core()->logger->log( "Unable to bounce contact: Contact not found for email: $contact_email", 'crm_email_webhooks' );
		}
	}
}