<?php

class BWFCRM_API_Get_Contact_Funnels extends BWFCRM_API_Base {
	public static $ins;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function __construct() {
		parent::__construct();
		$this->method = WP_REST_Server::READABLE;
		$this->route  = '/contacts/(?P<contact_id>[\\d]+)/funnels';
	}

	public function default_args_values() {
		return array(
			'contact_id' => '',
		);
	}

	public function process_api_call() {
		/** checking if search present in params **/

		$contact_id = $this->get_sanitized_arg( 'contact_id', 'key' );
		$offset     = $this->get_sanitized_arg( 'offset', 'key' );
		$limit      = $this->get_sanitized_arg( 'limit', 'key' );

		$offset = empty( $offset ) ? $this->pagination->offset : $offset;
		$limit  = empty( $offset ) ? $this->pagination->limit : $limit;

		if ( empty( $contact_id ) ) {
			return $this->error_response( __( 'Contact ID is mandatory', 'wp-marketing-automations-crm' ) );
		}

		$contact = new BWFCRM_Contact( $contact_id );

		if ( ! $contact->is_contact_exists() ) {
			$this->response_code = 404;

			return $this->error_response( __( 'No contact found with given id #' . $contact_id, 'wp-marketing-automations-crm' ) );
		}

		$contacts_funnel = array();

		$contacts_funnel['funnel'] = $contact->get_contact_funnels_array();

		if ( function_exists( 'WFACP_Core' ) ) {
			$contacts_funnel['funnel']['checkout'] = $contact->get_contact_checkout_array();
		}

		if ( function_exists( 'WFOB_Core' ) ) {
			$contacts_funnel['funnel']['order_bump'] = $contact->get_contact_order_bump_array();
		}

		if ( function_exists( 'WFOPP_Core' ) ) {
			$contacts_funnel['funnel']['optin'] = $contact->get_contact_optin_array();
		}

		if ( function_exists( 'WFOCU_Core' ) ) {
			$contacts_funnel['funnel']['upsells'] = $contact->get_contact_upsell_array();
		}

		$this->response_code = 200;
		$success_message     = __( 'Contacts funnels', 'wp-marketing-automations-crm' );

		return $this->success_response( $contacts_funnel, $success_message );
	}
}

if ( class_exists( 'WFFN_Core' ) ) {
	BWFCRM_API_Loader::register( 'BWFCRM_API_Get_Contact_Funnels' );
}
