<?php

class BWFCRM_API_Delete_Form_Feed extends BWFCRM_API_Base {

	public static $ins;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function default_args_values() {
		$args = array(
			'name' => '',
			'form' => '',
		);

		return $args;
	}

	public function __construct() {
		parent::__construct();
		$this->method        = WP_REST_Server::DELETABLE;
		$this->route         = '/form-feeds/(?P<feed_id>[\\d]+)';
		$this->response_code = 200;
	}

	public function process_api_call() {
		$feed_id = $this->get_sanitized_arg( 'feed_id' );
		if ( empty( $feed_id ) ) {
			return $this->error_response( __( 'Invalid / Empty form ID provided', 'wp-marketing-automations-crm' ), null, 400 );
		}

		$feed = new BWFCRM_Form_Feed( $feed_id );
		if ( ! $feed->is_feed_exists() ) {
			return $this->error_response( __( 'No form exists', 'wp-marketing-automations-crm' ), null, 500 );
		}

		$feed->delete();

		return $this->success_response( '', __( 'Form created', 'wp-marketing-automations-crm' ) );
	}
}


BWFCRM_API_Loader::register( 'BWFCRM_API_Delete_Form_Feed' );