<?php
/**
 * Merge Tag: Contact Address
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Business_Name
 */
class BWFCRM_View_Email_Browser_Link extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'View Email Browser Link', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'View Email Browser Link', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		return add_query_arg( array(
			'bwfan-action' => 'view_in_browser'
		), home_url() );
	}

	public function get_dummy_value( $atts = array() ) {
		return $this->get_value();
	}
}

BWFCRM_Core()->merge_tags->register( 'view_email_browser_link', 'BWFCRM_View_Email_Browser_Link', 'general' );
