<?php

defined( 'ABSPATH' ) || exit;

global $wp_locale;
$global_settings = BWFAN_Common::get_global_settings();
$required        = ( empty( $wfacp_id ) && ! isset( $required ) ) && isset( $global_settings['bwfan_dob_required'] ) ? $global_settings['bwfan_dob_required'] : $required;

if ( empty( $birthday_label ) ) {
	$birthday_label = ! empty( $global_settings['bwfan_birthday_field_label'] ) ? $global_settings['bwfan_birthday_field_label'] : __( 'Date of Birth', 'wp-marketing-automations-pro' );
}
$birthday_date = '';

if ( is_user_logged_in() ) {
	$user    = get_user_by( 'id', get_current_user_id() );
	$contact = new BWFCRM_Contact( $user->user_email );
	/** Get DOB from contact */
	$dob = $contact->get_field_by_slug( 'dob' );
	/** Get Dob from user meta */
	$user_dob      = get_user_meta( get_current_user_id(), 'bwfan_birthday_date', true );
	$birthday_date = empty( $dob ) ? $user_dob : $dob;
}
$birthday_date = empty( $birthday_date ) ? apply_filters( 'bwfan_dob_default_value', '' ) : $birthday_date;
$max           = current_time( 'Y-m-d', 1 );
$min           = BWFAN_PRO_Common::get_birthday_min_value();

$input_args  = 'type="date"';
$placeholder = '';
if ( 'wfacp-modern-label' === $label_position ) {
	if ( empty( $birthday_date ) ) {
		$input_args = 'type="text"';
	}
	$input_args  .= ' onfocus="(this.type=\'date\')" onblur="(this.value == \'\' ? this.type=\'text\' : \'\')"';
	$placeholder = ! empty( $placeholder_label ) ? $placeholder_label : $birthday_label;;
}
if ( empty( $wfacp_id ) && ! empty( $required ) ) {
	$class .= " validate-required";
} ?>
<div class="bwfan-birthday-section bwfan-birthday-section--checkout form-row form-row-wide <?php echo $label_position ?>">
    <p class="form-row form-row-wide <?php echo $class ?>" id="bwfan_birthday_field">
        <label for="bwfan_birthday_date" class="<?php echo $label_class ?>"><?php echo $birthday_label ?>
			<?php
			if ( ! empty( $required ) ) { ?>
                <abbr class="required" title="required">*</abbr>
			<?php }
			?>
        </label>
        <span class="woocommerce-input-wrapper">
            <input <?php echo $input_args ?> class="input-text <?php echo $input_class ?>" name="bwfan_birthday_date" id="bwfan_birthday_date" placeholder="<?php echo $placeholder ?>" value="<?php echo $birthday_date ?>" max="<?php echo esc_attr( $max ); ?>" <?php echo $min; ?> >
        </span>
    </p>
</div>
