<?php

class BWFAN_WLM_User_Level_Expire_Date extends BWFAN_Merge_Tag {

	private static $instance = null;

	public function __construct() {
		$this->tag_name        = 'wishlist_member_level_expire_date';
		$this->tag_description = __( 'WishList Member Level Expiry Date', 'autonami-automations-pro' );
		add_shortcode( 'bwfan_wishlist_member_level_expire_date', array( $this, 'parse_shortcode' ) );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Parse the merge tag and return its value.
	 *
	 * @param $attr
	 *
	 * @return mixed|string|void
	 */
	public function parse_shortcode( $attr ) {
		if ( true === BWFAN_Merge_Tag_Loader::get_data( 'is_preview' ) ) {
			return $this->get_dummy_preview();
		}

		$expire_date = BWFAN_Merge_Tag_Loader::get_data( 'expire_date' );

		if ( empty( $expire_date ) ) {
			return $this->parse_shortcode_output( '', $attr );
		}

		return $this->parse_shortcode_output( date( 'Y-m-d', $expire_date ), $attr );
	}

	/**
	 * Show dummy value of the current merge tag.
	 *
	 * @return string
	 *
	 * @todo:Hard values shouldn't be passed
	 */
	public function get_dummy_preview() {
		return date( 'Y-m-d' );
	}
}

/**
 * Register this merge tag to a group.
 */
if ( function_exists( 'bwfan_is_wlm_active' ) && bwfan_is_wlm_active() ) {
	BWFAN_Merge_Tag_Loader::register( 'wlm_user_level_expire_date', 'BWFAN_WLM_User_Level_Expire_Date', null, 'WooCommerce Membership' );
}
