<?php

class BWFCRM_API_Contact_Status_Change extends BWFCRM_API_Base {
	public static $ins;

	public function __construct() {
		parent::__construct();
		$this->method = WP_REST_Server::CREATABLE;
		$this->route  = '/contacts/(?P<contact_id>[\\d]+)/execute_status_action/(?P<status>[a-zA-Z0-9-]+)';
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function process_api_call() {
		$contact_id = $this->get_sanitized_arg( 'contact_id', 'text_field' );
		$status     = $this->get_sanitized_arg( 'status', 'text_field' );

		$contact = new BWFCRM_Contact( absint( $contact_id ) );
		if ( ! $contact->is_contact_exists() ) {
			return $this->error_response( __( 'Contact does not exists', 'wp-marketing-automations-crm' ) );
		}

		$result  = false;
		$message = __( 'Unable to perform requested action', 'wp-marketing-automations-crm' );
		switch ( $status ) {
			case 'resubscribe':
				$result = $contact->resubscribe();
				if ( true === $result ) {
					$message = __( 'Contact resubscribed', 'wp-marketing-automations-crm' );
				}
				break;
			case 'unsubscribe':
				$result = $contact->unsubscribe();
				if ( true === $result ) {
					$message = __( 'Contact unsubscribed', 'wp-marketing-automations-crm' );
				}
				break;
			case 'verify':
				$result = $contact->verify();
				if ( true === $result ) {
					$message = __( 'Contact subscribed', 'wp-marketing-automations-crm' );
				}
				break;
			case 'bounced':
				$result = $contact->mark_as_bounced();
				if ( true === $result ) {
					$message = __( 'Contact bounced', 'wp-marketing-automations-crm' );
				}
				break;
		}

		if ( ! $result ) {
			return $this->error_response( $message, null, 500 );
		}

		return $this->success_response( [ 'status' => $contact->get_display_status() ], $message );
	}
}

BWFCRM_API_Loader::register( 'BWFCRM_API_Contact_Status_Change' );
