<?php

class BWFCRM_Webhook_Postmark extends BWFCRM_Email_Webhook_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_name = "Postmark";
	}

	public function handle_webhook() {
		if ( ! is_array( $this->_data ) || empty( $this->_data ) ) {
			return;
		}

		$this->maybe_bounce_contact_email();
	}

	private function maybe_bounce_contact_email() {
		if ( ! is_array( $this->_data ) || ! isset( $this->_data['RecordType'] ) || ! is_email( $this->_data['Email'] ) ) {
			return;
		}

		/** filter to add record types for which contact can be marked as bounced */
		$record_types = apply_filters( 'bwfan_postmark_bounce_recordtypes', array( 'Bounce' ) );

		/** checking if the received record types is available in the bounce record types */
		if ( ! in_array( $this->_data['RecordType'], $record_types ) ) {
			return;
		}

		$this->mark_contact_bounce( $this->_data['Email'] );
	}
}

BWFCRM_Core()->email_webhooks->register( 'BWFCRM_Webhook_Postmark' );
