<?php
/**
 * Merge Tag: Unsubscribe Link
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Unsubscribe_Link
 */
class BWFCRM_Unsubscribe_Link extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Unsubscribe Link', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Unsubscribe Link', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		$global_settings = BWFAN_Common::get_global_settings();
		if ( ! isset( $global_settings['bwfan_unsubscribe_page'] ) || empty( $global_settings['bwfan_unsubscribe_page'] ) ) {
			return '';
		}

		$page      = absint( $global_settings['bwfan_unsubscribe_page'] );
		$page_link = get_permalink( $page );

		$unsubscribe_link = add_query_arg( array(
			'bwfan-action' => 'unsubscribe',
		), $page_link );

		$skip_name_email = apply_filters( 'bwfan_skip_name_email_from_unsubscribe_link', false );
		if ( false !== $skip_name_email ) {
			return apply_filters( 'bwfan_unsubscribe_link', $unsubscribe_link, [] );
		}

		if ( ! isset( $data['contact_id'] ) || empty( $data['contact_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		$contact_id = absint( $data['contact_id'] );
		$contact    = new BWFCRM_Contact( $contact_id );
		if ( ! $contact->is_contact_exists() ) {
			return BWFCRM_Common::crm_error( __( "No contact found with ID: $contact_id", 'wp-marketing-automations-crm' ) );
		}

		$uid = $contact->contact->get_uid();

		if ( ! empty( $uid ) ) {
			$unsubscribe_link = add_query_arg( array(
				'uid' => $uid,
			), $unsubscribe_link );
		}

		$broadcast_id = isset( $data['broadcast_id'] ) ? absint( $data['broadcast_id'] ) : 0;
		if ( ! empty( $broadcast_id ) ) {
			$unsubscribe_link = add_query_arg( array(
				'bid' => $broadcast_id,
			), $unsubscribe_link );
		}

		$form_feed_id = isset( $data['form_feed_id'] ) ? absint( $data['form_feed_id'] ) : 0;
		if ( ! empty( $form_feed_id ) ) {
			$unsubscribe_link = add_query_arg( array(
				'fid' => $form_feed_id,
			), $unsubscribe_link );
		}

		return apply_filters( 'bwfan_unsubscribe_link', $unsubscribe_link, [] );
	}

	public function get_dummy_value( $data = array() ) {
		return $this->get_value( $data );
	}
}

BWFCRM_Core()->merge_tags->register( 'unsubscribe_link', 'BWFCRM_Unsubscribe_Link', 'general' );