<?php
/**
 * Custom Filters Controller Class
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Custom_Filters_Controller
 */
class BWFCRM_Custom_Filters_Controller {
	private $_webhooks = [];

	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'load_custom_filters' ] );
	}

	public function load_custom_filters() {
		/** Load custom filter class files */
		$this->load_classes( 'custom_filters' );
		do_action( 'bwfcrm_custom_filters_loaded' );

		/** Load column preferences class files */
		$this->load_classes( 'column-preferences' );
		do_action( 'bwfcrm_column_preferences_loaded' );
	}

	public function load_classes( $folder ) {
		$dir = __DIR__ . '/' . $folder;
		foreach ( glob( $dir . '/class-*.php' ) as $_field_filename ) {
			$file_data = pathinfo( $_field_filename );
			if ( isset( $file_data['basename'] ) && 'index.php' === $file_data['basename'] ) {
				continue;
			}
			require_once( $_field_filename );
		}
	}
}

if ( class_exists( 'BWFCRM_Custom_Filters_Controller' ) ) {
	BWFCRM_Core::register( 'custom_filters', 'BWFCRM_Custom_Filters_Controller' );
}
