<?php
/**
 * Merge Tag: Contact Address
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Business_Address
 */
class BWFCRM_Business_Address extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Business Address', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Business Address', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		$global_settings = BWFAN_Common::get_global_settings();
		if ( ! isset( $global_settings['bwfan_setting_business_address'] ) || empty( $global_settings['bwfan_setting_business_address'] ) ) {
			return '';
		}

		return $global_settings['bwfan_setting_business_address'];
	}

	public function get_dummy_value( $data = array() ) {
		return $this->get_value( $data );
	}
}

BWFCRM_Core()->merge_tags->register( 'business_address', 'BWFCRM_Business_Address', 'general' );