<?php
/**
 * Funnels Controller Class
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Automations
 *
 */
class BWFCRM_Funnels {

	public function get_contact_funnels( $contact_id ) {
		if ( function_exists( 'WFACP_Core' ) ) {
			$db_results = self::get_contact_checkouts( $contact_id );
		}

		if ( function_exists( 'WFOPP_Core' ) ) {
			$optin_results = self::get_contact_optins( $contact_id );
			$db_results    = array_merge( $db_results, $optin_results );
		}

		$fids = array_unique( wp_list_pluck( $db_results, 'fid' ) );
		$fids = array_filter( array_map( 'absint', $fids ) );
		if ( function_exists( 'WFOB_Core' ) && array( $fids ) && count( $fids ) > 0 ) {
			$bump_results = self::get_contact_bumps( $contact_id, $fids );
			$db_results   = array_merge( $db_results, $bump_results );
		}

		if ( function_exists( 'WFOCU_Core' ) && array( $fids ) && count( $fids ) > 0 ) {
			$upsell_results = self::get_contact_upsells( $contact_id, $fids );
			$db_results     = array_merge( $db_results, $upsell_results );
		}

		if ( count( $db_results ) === 0 ) {
			return [];
		}

		$final_result = [];

		foreach ( $db_results as $db_result ) {
			$fid = $db_result['fid'];
			if ( empty( $fid ) ) {
				continue;
			}
			$funnel = new WFFN_Funnel( $fid );
			if ( ! ( $funnel instanceof WFFN_Funnel ) || $fid !== $funnel->get_id() ) {
				continue;
			}

			if ( isset( $final_result[ $fid ] ) ) {
				$final_result[ $fid ]['funnel_id']     = $fid;
				$final_result[ $fid ]['funnel_name']   = $funnel->get_title();
				$final_result[ $fid ]['in_checkout']   = ( true !== $final_result[ $fid ]['in_checkout'] ) ? self::is_in_checkout( $final_result, $db_result, $fid ) : true;
				$final_result[ $fid ]['in_optin']      = ( true !== $final_result[ $fid ]['in_optin'] ) ? self::is_in_optin( $final_result, $db_result, $fid ) : true;
				$final_result[ $fid ]['in_bump']       = ( true !== $final_result[ $fid ]['in_bump'] ) ? self::is_in_bump( $final_result, $db_result, $fid ) : true;
				$final_result[ $fid ]['in_upsell']     = ( true !== $final_result[ $fid ]['in_upsell'] ) ? self::is_in_upsell( $final_result, $db_result, $fid ) : true;
				$final_result[ $fid ]['total_revenue'] += isset( $db_result['total_revenue'] ) ? floatval( $db_result['total_revenue'] ) : 0;

				continue;
			}

			$final_result[ $fid ] = array(
				'funnel_id'     => $fid,
				'funnel_name'   => $funnel->get_title(),
				'in_checkout'   => self::is_in_checkout( $final_result, $db_result, $fid ),
				'in_optin'      => self::is_in_optin( $final_result, $db_result, $fid ),
				'in_bump'       => self::is_in_bump( $final_result, $db_result, $fid ),
				'in_upsell'     => self::is_in_upsell( $final_result, $db_result, $fid ),
				'total_revenue' => isset( $db_result['total_revenue'] ) ? floatval( $db_result['total_revenue'] ) : 0,
			);
		}

		usort( $final_result, function ( $a, $b ) {
			return $a['funnel_id'] > $b['funnel_id'] ? 1 : - 1;
		} );

		return [ 'records' => array_values( $final_result ) ];
	}

	public function get_contact_checkouts( $contact_id ) {
		global $wpdb;
		$query = "SELECT aero.fid as fid, aero.wfacp_id, aero.total_revenue as 'total_revenue' FROM " . $wpdb->prefix . 'bwf_contact' . " AS contact JOIN " . $wpdb->prefix . 'wfacp_stats' . " AS aero ON contact.id=aero.cid WHERE aero.cid=$contact_id AND (aero.fid != 0 OR aero.fid IS NOT NULL)";

		if ( ! empty( $orderby ) ) {
			$query .= " ORDER BY aero.date DESC";
		}

		return $wpdb->get_results( $query, ARRAY_A ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_optins( $contact_id ) {
		global $wpdb;
		$query = "SELECT optin.funnel_id as fid, optin.opid FROM " . $wpdb->prefix . 'bwf_contact' . " AS contact JOIN " . $wpdb->prefix . 'bwf_optin_entries' . " AS optin ON contact.id=optin.cid WHERE optin.cid=$contact_id AND (optin.funnel_id != 0 OR optin.funnel_id IS NOT NULL)";

		if ( ! empty( $orderby ) ) {
			$query .= " ORDER BY optin.date DESC";
		}

		return $wpdb->get_results( $query, ARRAY_A ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_bumps( $contact_id, $fid ) {
		global $wpdb;
		$fid = is_array( $fid ) ? implode( ',', $fid ) : $fid;

		$query = "SELECT bump.fid as fid, bump.bid, bump.converted as converted, bump.total as 'total_revenue' FROM " . $wpdb->prefix . 'wfob_stats' . " AS bump WHERE bump.cid=$contact_id AND bump.fid IN (" . $fid . ") AND (bump.fid != 0 OR bump.fid IS NOT NULL)";

		return $wpdb->get_results( $query, ARRAY_A ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_upsells( $contact_id, $fid ) {
		global $wpdb;
		$fid = is_array( $fid ) ? implode( ',', $fid ) : $fid;

		$query = "SELECT session.fid as fid, (CASE WHEN action_type_id = 4 THEN `value` END) AS `total_revenue`, session.id as session_id, event.action_type_id FROM " . $wpdb->prefix . 'wfocu_session' . " AS session LEFT JOIN " . $wpdb->prefix . 'wfocu_event' . " AS event ON session.id=event.sess_id WHERE session.cid=$contact_id AND session.fid IN (" . $fid . ") AND (session.fid != 0 OR session.fid IS NOT NULL)";

		return $wpdb->get_results( $query, ARRAY_A ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	/**
	 * @param $freuslt
	 * @param $db_result
	 * @param $fid
	 *
	 * @return string
	 */
	public function is_in_checkout( $freuslt, $db_result, $fid ) {
		if ( isset( $db_result['wfacp_id'] ) && $db_result['wfacp_id'] > 0 ) {
			return true;
		}
		if ( isset( $freuslt[ $fid ] ) && isset( $freuslt[ $fid ]['in_checkout'] ) ) {
			return $freuslt[ $fid ]['in_checkout'];
		}

		return null;
	}

	/**
	 * @param $freuslt
	 * @param $db_result
	 * @param $fid
	 *
	 * @return string
	 */
	public function is_in_optin( $freuslt, $db_result, $fid ) {
		if ( isset( $db_result['opid'] ) && $db_result['opid'] ) {
			return true;
		}
		if ( isset( $freuslt[ $fid ] ) && isset( $freuslt[ $fid ]['in_optin'] ) ) {
			return $freuslt[ $fid ]['in_optin'];
		}

		return null;
	}

	/**
	 * @param $freuslt
	 * @param $db_result
	 * @param $fid
	 *
	 * @return string
	 */
	public function is_in_bump( $freuslt, $db_result, $fid ) {
		if ( isset( $db_result['bid'] ) && $db_result['bid'] > 0 && isset( $db_result['converted'] ) ) {
			return absint( $db_result['converted'] ) > 0 ? true : false;
		}

		if ( isset( $freuslt[ $fid ] ) && isset( $freuslt[ $fid ]['in_bump'] ) ) {
			return $freuslt[ $fid ]['in_bump'];
		}

		return null;
	}

	/**
	 * @param $fresult
	 * @param $db_result
	 * @param $fid
	 *
	 * @return string
	 */
	public function is_in_upsell( $fresult, $db_result, $fid ) {
		if ( isset( $db_result['session_id'] ) && absint( $db_result['session_id'] ) > 0 && isset( $db_result['action_type_id'] ) && 2 === absint( $db_result['action_type_id'] ) && empty( $db_result['total_revenue'] ) ) {
			return false;
		}
		if ( isset( $db_result['session_id'] ) && $db_result['session_id'] > 0 && isset( $db_result['total_revenue'] ) ) {
			return ( '' !== $db_result['total_revenue'] );
		}
		if ( isset( $fresult[ $fid ] ) && isset( $fresult[ $fid ]['in_upsell'] ) ) {
			return $fresult[ $fid ]['in_upsell'];
		}

		return null;
	}

	public function get_contact_checkout( $contact_id ) {
		global $wpdb;
		$query = "SELECT p.post_title as 'name', aero.fid as 'funnel',aero.wfacp_id as wfacp_id, aero.total_revenue as 'amount', aero.order_id as 'order',funnel.title as funnel_name, DATE_FORMAT(aero.date, '%Y-%m-%dT%TZ') as 'date' 
				  FROM " . $wpdb->prefix . 'wfacp_stats' . " AS aero 
				  LEFT JOIN " . $wpdb->prefix . 'posts' . " as p ON aero.wfacp_id  = p.id
				  LEFT JOIN " . $wpdb->prefix . 'bwf_funnels' . " as funnel ON aero.fid=funnel.id
				  WHERE aero . cid = $contact_id AND ( aero.fid != 0 OR aero.fid IS NOT NULL ) order by aero . fid asc";

		return $wpdb->get_results( $query ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_bump( $contact_id ) {
		global $wpdb;

		$query = "SELECT p . post_title as 'name',p . ID as 'bump_id', bump . fid as 'funnel',bump.converted as converted, bump . total as 'amount', bump . oid as 'order',funnel . title as funnel_name, DATE_FORMAT( bump . date, '%Y-%m-%dT%TZ' ) as 'date'
				  FROM " . $wpdb->prefix . 'wfob_stats' . " as bump
				  LEFT JOIN " . $wpdb->prefix . 'posts' . " as p ON bump . bid = p . id
				  LEFT JOIN " . $wpdb->prefix . 'bwf_funnels' . " as funnel ON bump . fid = funnel . id
				  WHERE bump . cid = $contact_id AND ( bump.fid != 0 OR bump.fid IS NOT NULL ) order by bump . fid asc";

		return $wpdb->get_results( $query ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_optin( $contact_id ) {
		global $wpdb;
		$query = "SELECT p . post_title as 'name', optin . funnel_id as 'funnel', optin . step_id as 'id', optin.data as 'entry',funnel.title as funnel_name, DATE_FORMAT( optin . date, '%Y-%m-%dT%TZ' ) as 'date' 
					FROM " . $wpdb->prefix . 'bwf_optin_entries' . " as optin 
					LEFT JOIN " . $wpdb->prefix . 'posts' . " as p ON optin . step_id = p . id 
					LEFT JOIN " . $wpdb->prefix . 'bwf_funnels' . " as funnel ON optin.funnel_id = funnel.id
					WHERE optin . cid = $contact_id AND ( optin.funnel_id != 0 OR optin.funnel_id IS NOT NULL ) order by optin . funnel_id asc";

		return $wpdb->get_results( $query ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}

	public function get_contact_upsell( $contact_id ) {
		global $wpdb;
		$query = "SELECT event . object_id,event.action_type_id,event.value,
				  DATE_FORMAT( event . timestamp, '%Y-%m-%dT%TZ' ) as 'date',p . post_title as 'object_name',
				  'upsell' as 'type',session . order_id as order_id,session . fid as funnel_id,funnel . title as funnel_name
				  FROM " . $wpdb->prefix . 'wfocu_event' . " as event 
				  LEFT JOIN " . $wpdb->prefix . 'wfocu_session' . " as session ON event . sess_id = session . id
				  LEFT JOIN " . $wpdb->prefix . 'posts' . " as p ON event . object_id = p . id
				  LEFT JOIN " . $wpdb->prefix . 'bwf_funnels' . " as funnel ON session . fid = funnel . id
				  WHERE( event . action_type_id = 4 or event . action_type_id = 6 or event . action_type_id = 7 or event . action_type_id = 9 or event . action_type_id = 10 ) and session . cid = $contact_id
				  AND ( session . fid != 0 OR session . fid IS NOT NULL ) order by session . timestamp asc";

		return $wpdb->get_results( $query ); //phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
	}
}
