<?php
/**
 * Merge Tag: Confirmation link to mark contact.status = 1
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BWFCRM_Contact_Confirmation_Link extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Confirmation Link', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Confirmation Link', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		if ( ! isset( $data['contact_id'] ) || empty( $data['contact_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		if ( ! isset( $data['form_feed_id'] ) || empty( $data['form_feed_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		$contact = new BWFCRM_Contact( absint( $data['contact_id'] ) );
		$feed    = new BWFCRM_Form_Feed( absint( $data['form_feed_id'] ) );
		if ( ! $contact->is_contact_exists() || ! $feed->is_feed_exists() ) {
			return BWFCRM_Common::crm_error( __( 'Contact ID / Feed ID not valid', 'wp-marketing-automations-crm' ) );
		}

		$redirect_url = $feed->get_data( 'redirect_url' );
		if ( empty( $redirect_url ) || false === wp_http_validate_url( $redirect_url ) ) {
			$redirect_url = home_url( '/' );
		}

		return add_query_arg( [
			'bwfan-link'   => urlencode( esc_url_raw( $redirect_url ) ),
			'bwfan-action' => 'incentive',
			'feed-id'      => absint( $data['form_feed_id'] ),
			'bwfan-uid'    => $contact->contact->get_uid()
		], esc_url_raw( home_url( '/' ) ) );
	}

	public function get_dummy_value( $data = array() ) {
		return esc_url_raw( home_url( '/' ) );
	}
}

BWFCRM_Core()->merge_tags->register( 'contact_confirmation_link', 'BWFCRM_Contact_Confirmation_Link', 'general' );